/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public class RestrictionMatchRequest {
    private final List<RefChange> refChanges;
    private final Repository repository;
    private final List<RefRestrictionType> types;
    private final ApplicationUser user;

    private RestrictionMatchRequest(Builder builder) {
        this.repository = Objects.requireNonNull(builder.repository, "repository");
        this.refChanges = builder.refChanges.build();
        this.types = builder.types;
        this.user = builder.user;
    }

    @Nonnull
    public List<RefChange> getRefChanges() {
        return this.refChanges;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    @Nonnull
    public List<RefRestrictionType> getTypes() {
        return this.types;
    }

    @Nullable
    public ApplicationUser getUser() {
        return this.user;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<RefChange> refChanges;
        private final Repository repository;
        private final List<RefRestrictionType> types;
        private ApplicationUser user;

        public Builder(@Nonnull Repository repository, @Nonnull List<RefRestrictionType> types) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.types = Objects.requireNonNull(types, "types");
            this.refChanges = ImmutableList.builder();
        }

        @Nonnull
        public RestrictionMatchRequest build() {
            return new RestrictionMatchRequest(this);
        }

        @Nonnull
        public Builder refChange(@Nonnull RefChange value) {
            this.refChanges.add((Object)Objects.requireNonNull(value, "refChange"));
            return this;
        }

        @Nonnull
        public Builder refChanges(@Nonnull Iterable<RefChange> value) {
            this.refChanges.addAll(Objects.requireNonNull(value, "refChanges"));
            return this;
        }

        @Nonnull
        public Builder user(@Nullable ApplicationUser value) {
            this.user = value;
            return this;
        }
    }
}

