/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.repository.ref.restriction.AbstractSearchRequest;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherType;
import com.atlassian.bitbucket.scope.Scope;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Objects;

public class RestrictionSearchRequest
extends AbstractSearchRequest {
    private final RefMatcher matcher;
    private final List<RefMatcherType> matcherTypes;
    private final boolean effective;

    private RestrictionSearchRequest(Builder builder) {
        super(builder);
        this.matcher = builder.matcher;
        this.matcherTypes = builder.matcherTypeBuilder.build();
        this.effective = builder.effective;
    }

    @Nullable
    public RefMatcher getMatcher() {
        return this.matcher;
    }

    @Nonnull
    public List<RefMatcherType> getMatcherTypes() {
        return this.matcherTypes;
    }

    public boolean isEffective() {
        return this.effective;
    }

    public static class Builder
    extends AbstractSearchRequest.AbstractBuilder<Builder> {
        private final ImmutableList.Builder<RefMatcherType> matcherTypeBuilder = ImmutableList.builder();
        private boolean effective = true;
        private RefMatcher matcher;

        public Builder(@Nonnull Scope scope) {
            super(scope);
        }

        @Nonnull
        public RestrictionSearchRequest build() {
            return new RestrictionSearchRequest(this);
        }

        @Nonnull
        public Builder matcher(RefMatcher value) {
            this.matcher = value;
            return this.self();
        }

        @Nonnull
        public Builder matcherType(@Nonnull RefMatcherType value) {
            this.matcherTypeBuilder.add((Object)Objects.requireNonNull(value, "matcherType"));
            return this.self();
        }

        @Nonnull
        public Builder matcherTypes(@Nonnull Iterable<RefMatcherType> value) {
            this.matcherTypeBuilder.addAll(Objects.requireNonNull(value, "matcherTypes"));
            return this.self();
        }

        @Nonnull
        public Builder effective(boolean effective) {
            this.effective = effective;
            return this.self();
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

