/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository.ref.restriction;

import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.BuilderSupport;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;

public class SetRestrictionRequest {
    private final List<SshAccessKey> accessKeyGrants;
    private final List<String> groupGrants;
    private final List<ApplicationUser> userGrants;
    private final Scope scope;
    private final RefMatcher matcher;
    private final RefRestrictionType type;

    private SetRestrictionRequest(Builder builder) {
        this.accessKeyGrants = builder.accessKeyGrants.build();
        this.groupGrants = builder.groupGrants.build();
        this.scope = Objects.requireNonNull(builder.scope, "scope");
        this.matcher = Objects.requireNonNull(builder.matcher, "matcher");
        this.type = Objects.requireNonNull(builder.type, "type");
        this.userGrants = builder.userGrants.build();
    }

    @Nonnull
    public List<SshAccessKey> getAccessKeyGrants() {
        return this.accessKeyGrants;
    }

    @Nonnull
    public List<String> getGroupGrants() {
        return this.groupGrants;
    }

    @Nonnull
    public Scope getScope() {
        return this.scope;
    }

    @Nonnull
    public RefMatcher getMatcher() {
        return this.matcher;
    }

    @Nonnull
    public RefRestrictionType getType() {
        return this.type;
    }

    @Nonnull
    public List<ApplicationUser> getUserGrants() {
        return this.userGrants;
    }

    public static class Builder
    extends BuilderSupport {
        private final ImmutableList.Builder<SshAccessKey> accessKeyGrants = ImmutableList.builder();
        private final ImmutableList.Builder<String> groupGrants = ImmutableList.builder();
        private final Scope scope;
        private final ImmutableList.Builder<ApplicationUser> userGrants = ImmutableList.builder();
        private RefMatcher matcher;
        private RefRestrictionType type;

        public Builder(@Nonnull Scope scope, @Nonnull RefMatcher matcher, @Nonnull RefRestrictionType type) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.matcher = Objects.requireNonNull(matcher, "matcher");
            this.type = Objects.requireNonNull(type, "type");
        }

        @Nonnull
        public SetRestrictionRequest build() {
            return new SetRestrictionRequest(this);
        }

        @Nonnull
        public Builder grantAccessKeys(@Nonnull Iterable<SshAccessKey> value) {
            this.accessKeyGrants.addAll(Objects.requireNonNull(value, "accessKeyGrants"));
            return this;
        }

        @Nonnull
        public Builder grantGroups(@Nonnull Iterable<String> value) {
            this.groupGrants.addAll(Objects.requireNonNull(value, "groupGrants"));
            return this;
        }

        @Nonnull
        public Builder grantUsers(@Nonnull Iterable<ApplicationUser> value) {
            this.userGrants.addAll(Objects.requireNonNull(value, "userGrants"));
            return this;
        }
    }
}

