/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction;

import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProviderRegistry;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DefaultRefMatcherProviderRegistry
implements RefMatcherProviderRegistry {
    private final BundleContext bundleContext;
    private final ConcurrentMap<String, RefMatcherProvider> providers = new ConcurrentHashMap<String, RefMatcherProvider>();
    private ServiceTracker<RefMatcherProvider, RefMatcherProvider> serviceTracker;

    public DefaultRefMatcherProviderRegistry(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
    }

    public void destroy() {
        if (this.serviceTracker != null) {
            this.serviceTracker.close();
        }
    }

    public void initialize() {
        this.serviceTracker = new ServiceTracker(this.bundleContext, RefMatcherProvider.class.getName(), (ServiceTrackerCustomizer)new RegisteringCustomizer());
        this.serviceTracker.open();
    }

    @Override
    public RefMatcherProvider getProvider(@Nonnull String id) {
        return (RefMatcherProvider)this.providers.get(id);
    }

    @Override
    @Nonnull
    public List<RefMatcherProvider> getProviders() {
        return new ArrayList<RefMatcherProvider>(this.providers.values());
    }

    private class RegisteringCustomizer
    implements ServiceTrackerCustomizer<RefMatcherProvider, RefMatcherProvider> {
        private RegisteringCustomizer() {
        }

        public RefMatcherProvider addingService(ServiceReference<RefMatcherProvider> reference) {
            RefMatcherProvider provider = (RefMatcherProvider)DefaultRefMatcherProviderRegistry.this.bundleContext.getService(reference);
            if (DefaultRefMatcherProviderRegistry.this.providers.putIfAbsent(provider.getType().getId(), provider) == null) {
                return provider;
            }
            DefaultRefMatcherProviderRegistry.this.bundleContext.ungetService(reference);
            return null;
        }

        public void modifiedService(ServiceReference<RefMatcherProvider> reference, RefMatcherProvider service) {
        }

        public void removedService(ServiceReference<RefMatcherProvider> reference, RefMatcherProvider provider) {
            DefaultRefMatcherProviderRegistry.this.providers.remove(provider.getType().getId());
            DefaultRefMatcherProviderRegistry.this.bundleContext.ungetService(reference);
        }
    }
}

