/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.commit.CommitService;
import com.atlassian.bitbucket.commit.CommitsBetweenRequest;
import com.atlassian.bitbucket.event.project.ProjectDeletionRequestedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletionRequestedEvent;
import com.atlassian.bitbucket.event.user.GroupCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.license.LimitExceededException;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.project.ProjectType;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.ref.restriction.AccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.AccessGrantVisitor;
import com.atlassian.bitbucket.repository.ref.restriction.AccessKeyAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.GroupAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessRequest;
import com.atlassian.bitbucket.repository.ref.restriction.RefAccessType;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProviderRegistry;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionService;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.bitbucket.repository.ref.restriction.RestrictionMatchRequest;
import com.atlassian.bitbucket.repository.ref.restriction.RestrictionSearchRequest;
import com.atlassian.bitbucket.repository.ref.restriction.SetRestrictionRequest;
import com.atlassian.bitbucket.repository.ref.restriction.UnknownRefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.UserAccessGrant;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.ssh.SshKey;
import com.atlassian.bitbucket.ssh.event.SshKeyDeletedEvent;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.ApplicationUserEquality;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.user.UserType;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.repository.ref.restriction.AbstractRestrictionScopeVisitor;
import com.atlassian.stash.internal.repository.ref.restriction.SimpleAccessKeyAccessGrant;
import com.atlassian.stash.internal.repository.ref.restriction.SimpleGroupAccessGrant;
import com.atlassian.stash.internal.repository.ref.restriction.SimpleRefRestriction;
import com.atlassian.stash.internal.repository.ref.restriction.SimpleUserAccessGrant;
import com.atlassian.stash.internal.repository.ref.restriction.analytics.AnalyticsRefRestrictionAddedEvent;
import com.atlassian.stash.internal.repository.ref.restriction.analytics.AnalyticsRefRestrictionDeletedEvent;
import com.atlassian.stash.internal.repository.ref.restriction.analytics.AnalyticsRefRestrictionUpdatedEvent;
import com.atlassian.stash.internal.repository.ref.restriction.dao.AoAccessGrant;
import com.atlassian.stash.internal.repository.ref.restriction.dao.AoRefRestriction;
import com.atlassian.stash.internal.repository.ref.restriction.dao.RefRestrictionDao;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRefRestrictionService
implements RefRestrictionService {
    private static final Logger log = LoggerFactory.getLogger(DefaultRefRestrictionService.class);
    private static final int USER_GROUP_LIMIT = 500;
    private final int maxResourcesPerScope;
    private final int maxGrantedAccessPerResource;
    private final AuthenticationContext authenticationContext;
    private final CommitService commitService;
    private final RefRestrictionDao dao;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final ProjectSupplier projectSupplier;
    private final RepositorySupplier repositorySupplier;
    private final SshAccessKeyService sshAccessKeyService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final PermissionValidationService validationService;
    private final EscalatedSecurityContext withRepoAdmin;
    private final EscalatedSecurityContext withProjectAdmin;
    private final RefMatcherProviderRegistry refMatcherProviderRegistry;

    public DefaultRefRestrictionService(ApplicationPropertiesService propertiesService, AuthenticationContext authenticationContext, CommitService commitService, EventPublisher eventPublisher, I18nService i18nService, PermissionService permissionService, PermissionValidationService validationService, ProjectSupplier projectSupplier, RefRestrictionDao dao, RefMatcherProviderRegistry refMatcherProviderRegistry, RepositorySupplier repositorySupplier, SecurityService securityService, SshAccessKeyService sshAccessKeyService, TransactionTemplate transactionTemplate, UserService userService) {
        this.authenticationContext = authenticationContext;
        this.commitService = commitService;
        this.dao = dao;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.projectSupplier = projectSupplier;
        this.repositorySupplier = repositorySupplier;
        this.sshAccessKeyService = sshAccessKeyService;
        this.transactionTemplate = transactionTemplate;
        this.userService = userService;
        this.validationService = validationService;
        this.refMatcherProviderRegistry = refMatcherProviderRegistry;
        this.maxResourcesPerScope = propertiesService.getPluginProperty("plugin.bitbucket-ref-restriction.max.resources", 100);
        this.maxGrantedAccessPerResource = propertiesService.getPluginProperty("plugin.bitbucket-ref-restriction.max.resource.entities", 50);
        this.withRepoAdmin = securityService.withPermission(Permission.REPO_ADMIN, "Ref restrictions");
        this.withProjectAdmin = securityService.withPermission(Permission.PROJECT_ADMIN, "Ref restrictions");
    }

    @Override
    @Nullable
    public RefRestriction getById(int id) {
        return (RefRestriction)this.transactionTemplate.execute(() -> {
            AoRefRestriction storedRef = this.dao.getById(id);
            if (storedRef == null) {
                return null;
            }
            Scope scope = this.getScope(storedRef);
            if (scope == null) {
                log.info("Scope with type {} and ID {} does not exist, cleaning up ref restriction: \\{id: {}, type: {}, value: {}\\}", new Object[]{storedRef.getScopeType(), storedRef.getResourceId(), storedRef.getID(), storedRef.getMatcherType(), storedRef.getMatcherId()});
                this.dao.delete(storedRef);
                return null;
            }
            this.validateNotPersonalProject(scope);
            this.validatePermission(scope);
            return this.toRefRestriction(storedRef, scope);
        });
    }

    @Override
    @Nonnull
    public Map<RefChange, List<RefRestriction>> match(final @Nonnull RestrictionMatchRequest request) {
        Objects.requireNonNull(request, "request");
        Repository repository = request.getRepository();
        this.validationService.validateForRepository(repository, Permission.REPO_ADMIN);
        ArrayListMultimap result = ArrayListMultimap.create();
        RepositoryScope repositoryScope = Scopes.repository((Repository)repository);
        ProjectScope projectScope = Scopes.project((Project)repository.getProject());
        ImmutableList<Scope> additiveScopes = DefaultRefRestrictionService.getInheritedScopes((Scope)repositoryScope);
        Iterable restrictions = (Iterable)this.transactionTemplate.execute(() -> (List)this.dao.find((Collection<Scope>)additiveScopes, request.getTypes(), null, null, PageUtils.newRequest((int)0, (int)(this.maxResourcesPerScope * 2))).stream().map(aoRefRestriction -> {
            switch (aoRefRestriction.getScopeType()) {
                case PROJECT: {
                    return this.toRefRestriction((AoRefRestriction)aoRefRestriction, (Scope)projectScope, (Scope)repositoryScope);
                }
                case REPOSITORY: {
                    return this.toRefRestriction((AoRefRestriction)aoRefRestriction, (Scope)repositoryScope);
                }
            }
            log.warn("Scope of type '{}' is not supported, cleaning up ref restriction: \\{id: {}, type: {}, value: {}\\}", new Object[]{aoRefRestriction.getScopeType(), aoRefRestriction.getID(), aoRefRestriction.getMatcherType(), aoRefRestriction.getMatcherId()});
            this.dao.delete((AoRefRestriction)aoRefRestriction);
            return null;
        }).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList()));
        AccessGrantVisitor<Boolean> appliesToUser = new AccessGrantVisitor<Boolean>(){
            private Set<String> lowerCasedGroups;

            @Override
            public Boolean visit(@Nonnull AccessKeyAccessGrant grant) {
                return ApplicationUserEquality.equals((ApplicationUser)request.getUser(), (Object)grant.getAccessKey().getKey().getUser());
            }

            @Override
            public Boolean visit(@Nonnull GroupAccessGrant grant) {
                return this.getGroups().contains(IdentifierUtils.toLowerCase((String)grant.getGroup()));
            }

            @Override
            public Boolean visit(@Nonnull UserAccessGrant grant) {
                return ApplicationUserEquality.equals((ApplicationUser)request.getUser(), (Object)grant.getUser());
            }

            private Set<String> getGroups() {
                if (this.lowerCasedGroups == null) {
                    this.lowerCasedGroups = DefaultRefRestrictionService.this.getLowerCasedGroupsForUser(request.getUser());
                }
                return this.lowerCasedGroups;
            }
        };
        ArrayList<RefRestriction> activeRestrictions = new ArrayList<RefRestriction>();
        for (RefChange refChange : request.getRefChanges()) {
            MinimalRef ref = refChange.getRef();
            Page strippedCommits = null;
            EnumSet<RefRestrictionType> restrictionTypesToExclude = EnumSet.noneOf(RefRestrictionType.class);
            for (RefRestriction restriction : restrictions) {
                if (!restriction.getMatcher().matches(ref)) continue;
                if (restriction.getAccessGrants().stream().anyMatch(grant -> (Boolean)grant.accept(appliesToUser))) {
                    restrictionTypesToExclude.add(restriction.getType());
                    continue;
                }
                switch (restriction.getType()) {
                    case NO_CREATES: {
                        if (refChange.getType() != RefChangeType.ADD) break;
                        activeRestrictions.add(restriction);
                        break;
                    }
                    case NO_DELETES: {
                        if (refChange.getType() != RefChangeType.DELETE) break;
                        activeRestrictions.add(restriction);
                        break;
                    }
                    case FAST_FORWARD_ONLY: {
                        if (refChange.getType() != RefChangeType.UPDATE) break;
                        if (strippedCommits == null) {
                            strippedCommits = this.commitService.getCommitsBetween(new CommitsBetweenRequest.Builder(repository).include(refChange.getFromHash(), new String[0]).exclude(refChange.getToHash(), new String[0]).build(), PageUtils.newRequest((int)0, (int)1));
                        }
                        if (strippedCommits.getSize() <= 0) break;
                        activeRestrictions.add(restriction);
                        break;
                    }
                    case PULL_REQUEST_ONLY: {
                        if (refChange.getType() != RefChangeType.UPDATE) break;
                        activeRestrictions.add(restriction);
                        break;
                    }
                    case READ_ONLY: {
                        activeRestrictions.add(restriction);
                    }
                }
            }
            activeRestrictions.stream().filter(active -> !restrictionTypesToExclude.contains((Object)active.getType())).forEach(arg_0 -> DefaultRefRestrictionService.lambda$match$5((Multimap)result, refChange, arg_0));
            activeRestrictions.clear();
        }
        return DefaultRefRestrictionService.asMapOfLists((Multimap<RefChange, RefRestriction>)result);
    }

    @Override
    public boolean hasPermission(@Nonnull RefAccessRequest request) {
        List<MinimalRef> refs = Objects.requireNonNull(request, "request").getRefs();
        if (refs == null || refs.isEmpty()) {
            return true;
        }
        if (!this.permissionService.hasRepositoryPermission(request.getRepository(), Permission.REPO_WRITE)) {
            return false;
        }
        ArrayList<RefChange> refChanges = new ArrayList<RefChange>();
        request.getRefs().forEach(ref -> refChanges.add((RefChange)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().fromHash("fromHash")).toHash("toHash")).ref(ref)).type(DefaultRefRestrictionService.mapToRefChangeType(request.getAccessType()))).build()));
        RestrictionMatchRequest.Builder matchRequestBuilder = new RestrictionMatchRequest.Builder(request.getRepository(), (List<RefRestrictionType>)DefaultRefRestrictionService.getRestrictionTypes(request)).user(this.authenticationContext.getCurrentUser()).refChanges(refChanges);
        Map restrictions = (Map)this.withRepoAdmin.call(() -> this.match(matchRequestBuilder.build()));
        return restrictions.isEmpty();
    }

    @EventListener
    public void onGroupDeleted(GroupCleanupEvent event) {
        this.transactionTemplate.execute(() -> {
            this.dao.deleteForGroup(event.getGroup());
            return null;
        });
    }

    @EventListener
    public void onRepositoryDeletionRequested(RepositoryDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.dao.deleteForScope((Scope)Scopes.repository((Repository)event.getRepository()));
        }
    }

    @EventListener
    public void onProjectDeletionRequested(ProjectDeletionRequestedEvent event) {
        if (!event.isCanceled()) {
            this.dao.deleteForScope((Scope)Scopes.project((Project)event.getProject()));
        }
    }

    @EventListener
    public void onSshKeyDeleted(SshKeyDeletedEvent event) {
        this.transactionTemplate.execute(() -> {
            this.dao.deleteForAccessKey(event.getKey().getId());
            return null;
        });
    }

    @Override
    public boolean removeRefRestriction(int id) {
        return (Boolean)this.transactionTemplate.execute(() -> this.tryDeleteRestriction(this.dao.getById(id)));
    }

    @Override
    @Nonnull
    public Page<RefRestriction> search(@Nonnull RestrictionSearchRequest request, @Nonnull PageRequest pageRequest) {
        Objects.requireNonNull(request, "request");
        Scope scope = request.getScope();
        this.validateNotPersonalProject(scope);
        this.validatePermission(scope);
        ImmutableList effectiveScopes = request.isEffective() ? DefaultRefRestrictionService.getInheritedScopes(scope) : ImmutableList.of((Object)scope);
        PageRequest realPageRequest = PageUtils.newRequest((int)pageRequest.getStart(), (int)pageRequest.getLimit());
        return (Page)this.transactionTemplate.execute(() -> this.dao.find((Collection<Scope>)effectiveScopes, request.getTypes(), request.getMatcher(), request.getMatcherTypes(), realPageRequest).transform(aoRefRestriction -> this.toRefRestriction((AoRefRestriction)aoRefRestriction, this.getScopeFromRestriction((AoRefRestriction)aoRefRestriction), scope)));
    }

    @Override
    @Nonnull
    public RefRestriction setRestriction(@Nonnull SetRestrictionRequest request) {
        return (RefRestriction)this.transactionTemplate.execute(() -> {
            Scope scope = request.getScope();
            this.validateNotPersonalProject(scope);
            this.validatePermission(scope);
            this.validateAccessGrantsWithinResourceLimits(request.getGroupGrants().size() + request.getUserGrants().size() + request.getAccessKeyGrants().size());
            List accessKeyIds = (List)request.getAccessKeyGrants().stream().map(SshAccessKey::getKey).map(SshKey::getId).collect(MoreCollectors.toImmutableList());
            List userIds = (List)request.getUserGrants().stream().map(ApplicationUser::getId).collect(MoreCollectors.toImmutableList());
            List<String> groups = request.getGroupGrants();
            AoRefRestriction existing = this.dao.get(scope, request.getType(), request.getMatcher());
            if (existing == null) {
                this.validateWithinResourceLimits(scope);
                AoRefRestriction aoRefRestriction = this.dao.create(request);
                RefRestriction restriction = this.toRefRestriction(aoRefRestriction, scope);
                this.eventPublisher.publish((Object)new AnalyticsRefRestrictionAddedEvent(this, restriction));
                return restriction;
            }
            RefRestriction restriction = this.toRefRestriction(this.dao.setAccessGrants(existing, groups, userIds, accessKeyIds), scope);
            this.eventPublisher.publish((Object)new AnalyticsRefRestrictionUpdatedEvent(this, restriction, this.toRefRestriction(existing, scope)));
            return restriction;
        });
    }

    @Override
    @Nonnull
    public List<RefRestriction> setRestrictions(@Nonnull Collection<SetRestrictionRequest> requests) {
        return (List)this.transactionTemplate.execute(() -> requests.stream().map(this::setRestriction).collect(Collectors.toList()));
    }

    private static Map<RefChange, List<RefRestriction>> asMapOfLists(Multimap<RefChange, RefRestriction> multimap) {
        return multimap.asMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ArrayList((Collection)e.getValue())));
    }

    private static ImmutableList<RefRestrictionType> getRestrictionTypes(RefAccessRequest request) {
        ImmutableList.Builder builder = new ImmutableList.Builder().add((Object)RefRestrictionType.READ_ONLY);
        if (request.getAccessType() == RefAccessType.DELETE) {
            builder.add((Object)RefRestrictionType.NO_DELETES);
        } else if (request.getAccessType() == RefAccessType.CREATE) {
            builder.add((Object)RefRestrictionType.NO_CREATES);
        }
        return builder.build();
    }

    private static RefChangeType mapToRefChangeType(RefAccessType type) {
        return switch (type) {
            default -> throw new MatchException(null, null);
            case RefAccessType.DELETE -> RefChangeType.DELETE;
            case RefAccessType.UPDATE -> RefChangeType.UPDATE;
            case RefAccessType.CREATE -> RefChangeType.ADD;
        };
    }

    private Map<Integer, ApplicationUser> findUsers(Set<Integer> userIds) {
        if (userIds.isEmpty()) {
            return Collections.emptyMap();
        }
        Set users = this.userService.getUsersById(userIds, true);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ApplicationUser user : users) {
            builder.put((Object)user.getId(), (Object)user);
        }
        return builder.build();
    }

    @Nonnull
    private static ImmutableList<Scope> getInheritedScopes(Scope scope) {
        return (ImmutableList)scope.accept((ScopeVisitor)new ScopeVisitor<ImmutableList<Scope>>(){

            public ImmutableList<Scope> visit(@Nonnull ProjectScope scope) {
                return ImmutableList.of((Object)scope);
            }

            public ImmutableList<Scope> visit(@Nonnull RepositoryScope scope) {
                if (scope.getProject().getType() == ProjectType.PERSONAL) {
                    return ImmutableList.of((Object)scope);
                }
                return ImmutableList.of((Object)scope, (Object)Scopes.project((Project)scope.getProject()));
            }
        });
    }

    private Set<String> getLowerCasedGroupsForUser(ApplicationUser user) {
        if (user == null || user.getType() != UserType.NORMAL) {
            return Collections.emptySet();
        }
        PagedIterable groupsForUser = new PagedIterable(request -> this.userService.findGroupsByUser(user.getName(), request), PageUtils.newRequest((int)0, (int)500));
        return Sets.newHashSet((Iterable)groupsForUser);
    }

    private Scope getScope(AoRefRestriction storedRef) {
        switch (storedRef.getScopeType()) {
            case PROJECT: {
                Project project = this.projectSupplier.getById(storedRef.getResourceId().intValue());
                if (project == null) {
                    return null;
                }
                return Scopes.project((Project)project);
            }
            case REPOSITORY: {
                Repository repository = this.repositorySupplier.getById(storedRef.getResourceId().intValue());
                if (repository == null) {
                    return null;
                }
                return Scopes.repository((Repository)repository);
            }
        }
        throw new UnsupportedOperationException("Ref restrictions cannot be managed at scope type: " + String.valueOf(storedRef.getScopeType()));
    }

    private RefRestriction toRefRestriction(AoRefRestriction restriction, Scope scope) {
        return this.toRefRestriction(restriction, scope, scope);
    }

    private RefRestriction toRefRestriction(AoRefRestriction restriction, Scope definedScope, Scope contextScope) {
        Optional<RefMatcher> optionalRefMatcher;
        List<AccessGrant> accessGrants = this.toAccessGrant(restriction.getAccessGrants(), definedScope);
        RefMatcherProvider provider = this.refMatcherProviderRegistry.getProvider(restriction.getMatcherType());
        if (provider != null && (optionalRefMatcher = provider.create(contextScope, restriction.getMatcherId())).isPresent()) {
            RefMatcher refMatcher = optionalRefMatcher.get();
            return new SimpleRefRestriction(restriction.getID(), definedScope, refMatcher, RefRestrictionType.forId(restriction.getType()), accessGrants);
        }
        UnknownRefMatcher unknownMatcher = new UnknownRefMatcher.Builder().matcherId(restriction.getMatcherId()).typeId(restriction.getType()).build();
        return new SimpleRefRestriction(restriction.getID(), definedScope, unknownMatcher, RefRestrictionType.forId(restriction.getType()), accessGrants);
    }

    private Scope getScopeFromRestriction(AoRefRestriction aoRefRestriction) {
        ScopeType type = aoRefRestriction.getScopeType();
        Integer resourceId = aoRefRestriction.getResourceId();
        switch (type) {
            case REPOSITORY: {
                return Scopes.repository((Repository)this.repositorySupplier.getById(resourceId.intValue()));
            }
            case PROJECT: {
                return Scopes.project((Project)this.projectSupplier.getById(resourceId.intValue()));
            }
        }
        throw new UnsupportedOperationException("Ref restrictions cannot be managed at scope type: " + String.valueOf(type));
    }

    private Optional<SshAccessKey> resolveSshAccessKey(Scope scope, final AoAccessGrant aoAccessGrant) {
        return (Optional)scope.accept((ScopeVisitor)new AbstractRestrictionScopeVisitor<Optional<SshAccessKey>>(){

            public Optional<SshAccessKey> visit(@Nonnull ProjectScope projectScope) {
                return (Optional)DefaultRefRestrictionService.this.withProjectAdmin.call(() -> DefaultRefRestrictionService.this.sshAccessKeyService.getByKeyAndProject(aoAccessGrant.getAccessKeyId().intValue(), projectScope.getProject()));
            }

            public Optional<SshAccessKey> visit(@Nonnull RepositoryScope repositoryScope) {
                Repository repository = repositoryScope.getRepository();
                Optional key = DefaultRefRestrictionService.this.sshAccessKeyService.getByKeyAndRepository(aoAccessGrant.getAccessKeyId().intValue(), repository);
                if (!key.isPresent()) {
                    key = (Optional)DefaultRefRestrictionService.this.withProjectAdmin.call(() -> DefaultRefRestrictionService.this.sshAccessKeyService.getByKeyAndProject(aoAccessGrant.getAccessKeyId().intValue(), repository.getProject()));
                }
                return key;
            }
        });
    }

    private List<AccessGrant> toAccessGrant(AoAccessGrant[] aoAccessGrants, Scope scope) {
        Map<Integer, ApplicationUser> users = this.findUsers(Lists.newArrayList((Object[])aoAccessGrants).stream().map(AoAccessGrant::getUserId).filter(Objects::nonNull).collect(Collectors.toSet()));
        ArrayList accessGrants = Lists.newArrayList();
        for (AoAccessGrant aoAccessGrant : aoAccessGrants) {
            if (aoAccessGrant.getUserId() != null) {
                accessGrants.add(new SimpleUserAccessGrant(users.get(aoAccessGrant.getUserId())));
                continue;
            }
            if (aoAccessGrant.getAccessKeyId() != null) {
                this.resolveSshAccessKey(scope, aoAccessGrant).map(SimpleAccessKeyAccessGrant::new).ifPresent(accessGrants::add);
                continue;
            }
            accessGrants.add(new SimpleGroupAccessGrant(aoAccessGrant.getGroup()));
        }
        return accessGrants;
    }

    private boolean tryDeleteRestriction(AoRefRestriction restriction) {
        if (restriction == null) {
            return false;
        }
        Scope scope = this.getScope(restriction);
        if (scope == null) {
            return false;
        }
        this.validateNotPersonalProject(scope);
        this.validatePermission(scope);
        this.dao.delete(restriction);
        this.eventPublisher.publish((Object)new AnalyticsRefRestrictionDeletedEvent(this, this.toRefRestriction(restriction, scope)));
        return true;
    }

    private void validateAccessGrantsWithinResourceLimits(Integer requestedAccessGrants) {
        if (requestedAccessGrants > this.maxGrantedAccessPerResource) {
            throw new LimitExceededException(this.i18nService.createKeyedMessage("bitbucket.branch.permission.too.many.permitted.entities", new Object[]{this.maxGrantedAccessPerResource}));
        }
    }

    private void validateNotPersonalProject(Scope scope) {
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                if (scope.getProject().getType() == ProjectType.PERSONAL) {
                    throw new ArgumentValidationException(DefaultRefRestrictionService.this.i18nService.createKeyedMessage("bitbucket.branch.permission.illegal.personalproject", new Object[0]));
                }
                return null;
            }
        });
    }

    private void validatePermission(Scope scope) {
        scope.accept((ScopeVisitor)new AbstractRestrictionScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                DefaultRefRestrictionService.this.validationService.validateForProject(projectScope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                DefaultRefRestrictionService.this.validationService.validateForRepository(repositoryScope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
    }

    private void validateWithinResourceLimits(Scope scope) {
        if (this.dao.count(scope) >= this.maxResourcesPerScope) {
            scope.accept((ScopeVisitor)new AbstractRestrictionScopeVisitor<Void>(){

                public Void visit(@Nonnull ProjectScope projectScope) {
                    throw new LimitExceededException(DefaultRefRestrictionService.this.i18nService.createKeyedMessage("bitbucket.branch.permission.project.too.many.restricted.refs", new Object[]{DefaultRefRestrictionService.this.maxResourcesPerScope}));
                }

                public Void visit(@Nonnull RepositoryScope repositoryScope) {
                    throw new LimitExceededException(DefaultRefRestrictionService.this.i18nService.createKeyedMessage("bitbucket.branch.permission.too.many.restricted.refs", new Object[]{DefaultRefRestrictionService.this.maxResourcesPerScope}));
                }
            });
        }
    }

    private static /* synthetic */ void lambda$match$5(Multimap result, RefChange refChange, RefRestriction active) {
        result.put((Object)refChange, (Object)active);
    }
}

