/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.hook.repository.MergeHookRequest;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHook;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.RepositoryHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryHookTrigger;
import com.atlassian.bitbucket.hook.repository.StandardRepositoryHookTrigger;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryRef;
import com.atlassian.bitbucket.repository.SimpleRefChange;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionService;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.bitbucket.repository.ref.restriction.RestrictionMatchRequest;
import com.atlassian.bitbucket.scm.git.hook.GitRebaseHookRequest;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class RestrictionEnforcer
implements PreRepositoryHook<RepositoryHookRequest> {
    private static final String BOUNCER_ASCII_ART = "                            *%%%%%.                            \n                        %%%         %%%                        \n                     ,%#               %%                      \n                    %%                   %%                    \n                   %#                     %%                   \n                  %%                       %                   \n                  %(                       %%                  \n                  %%%%%%%%%%%%%%%%%%%%%%%%%%%                  \n                %#%*%#///////%# %%///////%%%%%%                \n               ,% %*%%******%#   %%******%(%%,%                \n                 %%/ %%/**%%/%%%%%%%(**#%( %%#                 \n                  %%          %%%          %(                  \n                   %                      .%                   \n                   *%        %%%%%       .%                    \n                     %#                 %%                     \n                      .%%            .%%                       \n                      .%%.%%,     %%%.%%/                      \n                %%%%%%##%.  #%%%%%.  .%((%%%%%%                \n            %%#(((((((((%%,         #%%(((((((((#%%.           \n      %%%((((((((((((((((((%%%, .%%%((((((((((((((((((#%%*     \n    %%(((((((((((((((((((((((((%(((((((((((((((((((((((((#%.   \n  ,%(((((((((((((((((((((((((((((((((((((((((((((((((((((((%#  \n  %#((((((((((((((((((((((((((((((((((((((((((((((((((((((((%  \n  %%%%%%%%%%%%%(((((((((((((((((((((((((((((((((%%%%%%%%%%%%%  \n %%            %####((((((###%%%%%%%%#(((((((((%            ,% \n,%             %%%%%%#.               %%%((((((%*            %%\n#%                                       %%%#                %%\n.%                             .%%%%%%%%%                    %#\n %                         #%%%                              % \n %                     %%%%                                  %*\n/%************/#%%%%%%######%%*                        ..,*/(%%\n              %%######(((((((##################%%              \n              %%######(((((((((((((((((((((((((%%              \n//////////////%%%%%%%%#########################%%/////////  ///";
    private static final String SEPARATOR_LINE = "----------------------------------------------------\n";
    private final boolean asciiArtEnabled;
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final RefRestrictionService restrictionService;
    private final EscalatedSecurityContext withRepoAdmin;

    public RestrictionEnforcer(AuthenticationContext authenticationContext, I18nService i18nService, ApplicationPropertiesService propertiesService, RefRestrictionService restrictionService, SecurityService securityService) {
        this.asciiArtEnabled = propertiesService.getPluginProperty("plugin.ref-restriction.feature.ascii.art", true);
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.restrictionService = restrictionService;
        this.withRepoAdmin = securityService.withPermission(Permission.REPO_ADMIN, "For branch permission");
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull RepositoryHookRequest request) {
        RestrictionMatchRequest matchRequest;
        Map toBeChecked;
        RepositoryHookTrigger trigger = request.getTrigger();
        if (trigger == StandardRepositoryHookTrigger.MERGE) {
            return RepositoryHookResult.accepted();
        }
        Repository repository = request.getRepository();
        Collection refChanges = request.getRefChanges();
        if (request.isDryRun()) {
            if (request instanceof GitRebaseHookRequest) {
                return this.preUpdateRebaseDryRun((GitRebaseHookRequest)request);
            }
            if (request instanceof MergeHookRequest) {
                return this.preUpdateMergeDryRun((MergeHookRequest)request);
            }
        }
        if ((toBeChecked = (Map)this.withRepoAdmin.call(() -> this.lambda$preUpdate$0(matchRequest = new RestrictionMatchRequest.Builder(repository, Collections.emptyList()).user(this.authenticationContext.getCurrentUser()).refChanges(refChanges).build()))).isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        TreeMultimap errors = TreeMultimap.create(Comparator.comparing(refChange -> refChange.getRef().getId()), (Comparator)Ordering.natural());
        for (Map.Entry entry : toBeChecked.entrySet()) {
            RefChange refChange2 = (RefChange)entry.getKey();
            String refId = refChange2.getRef().getId();
            String displayId = refChange2.getRef().getDisplayId();
            List restrictions = (List)entry.getValue();
            for (RefRestriction restriction : restrictions) {
                switch (restriction.getType()) {
                    case NO_DELETES: {
                        errors.put((Object)refChange2, (Object)this.i18nService.getMessage("bitbucket.branch.permission.reject.no.delete", new Object[]{displayId}));
                        break;
                    }
                    case FAST_FORWARD_ONLY: {
                        errors.put((Object)refChange2, (Object)this.i18nService.getMessage("bitbucket.branch.permission.reject.fast.forward.only", new Object[]{refId}));
                        break;
                    }
                    case PULL_REQUEST_ONLY: {
                        if (trigger == StandardRepositoryHookTrigger.PULL_REQUEST_MERGE) break;
                        errors.put((Object)refChange2, (Object)this.i18nService.getMessage("bitbucket.branch.permission.reject.pull.request.only", new Object[]{refId}));
                        break;
                    }
                    case READ_ONLY: {
                        errors.put((Object)refChange2, (Object)this.i18nService.getMessage("bitbucket.branch.permission.reject.read.only", new Object[]{refId}));
                        break;
                    }
                    case NO_CREATES: {
                        errors.put((Object)refChange2, (Object)this.i18nService.getMessage("bitbucket.branch.permission.reject.no.create", new Object[]{refId}));
                    }
                }
            }
        }
        if (errors.isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        String checkSettings = this.i18nService.getMessage("bitbucket.branch.permission.check.settings.administrator", new Object[0]);
        if (request.getScmHookDetails().isPresent()) {
            StringBuilder detailsBuilder = new StringBuilder();
            if (this.asciiArtEnabled) {
                detailsBuilder.append(BOUNCER_ASCII_ART).append("\n");
            }
            detailsBuilder.append(SEPARATOR_LINE);
            for (String error : errors.values()) {
                detailsBuilder.append(error).append("\n");
            }
            detailsBuilder.append(checkSettings).append("\n");
            detailsBuilder.append(SEPARATOR_LINE).append("\n");
            String details = detailsBuilder.toString();
            return RepositoryHookResult.rejected((String)details, (String)details);
        }
        RepositoryHookResult.Builder builder = new RepositoryHookResult.Builder();
        for (String error : errors.values()) {
            builder.veto(error, checkSettings);
        }
        return builder.build();
    }

    private boolean canMerge(RepositoryRef fromRef, RepositoryRef toRef) {
        ImmutableList types = ImmutableList.of((Object)((Object)RefRestrictionType.READ_ONLY));
        RestrictionMatchRequest request = new RestrictionMatchRequest.Builder(toRef.getRepository(), (List<RefRestrictionType>)types).refChange((RefChange)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().fromHash(fromRef.getLatestCommit())).to((Ref)toRef)).type(RefChangeType.UPDATE)).build()).user(this.authenticationContext.getCurrentUser()).build();
        return ((Map)this.withRepoAdmin.call(() -> this.restrictionService.match(request))).isEmpty();
    }

    private boolean canRebase(Repository repository, Branch branch, String upstream) {
        ImmutableList types = ImmutableList.of((Object)((Object)RefRestrictionType.PULL_REQUEST_ONLY), (Object)((Object)RefRestrictionType.READ_ONLY));
        RestrictionMatchRequest request = new RestrictionMatchRequest.Builder(repository, (List<RefRestrictionType>)types).refChange((RefChange)((SimpleRefChange.Builder)((SimpleRefChange.Builder)((SimpleRefChange.Builder)new SimpleRefChange.Builder().from((Ref)branch)).toHash(upstream)).type(RefChangeType.UPDATE)).build()).user(this.authenticationContext.getCurrentUser()).build();
        return (Boolean)this.withRepoAdmin.call(() -> this.restrictionService.match(request).isEmpty());
    }

    private RepositoryHookResult preUpdateMergeDryRun(@Nonnull MergeHookRequest request) {
        RepositoryRef toRef = request.getToRef();
        if (this.canMerge(request.getFromRef(), toRef)) {
            return RepositoryHookResult.accepted();
        }
        return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.branch.permission.merge.check.summary", new Object[0]), (String)this.i18nService.getMessage("bitbucket.branch.permission.merge.check", new Object[]{toRef.getDisplayId()}));
    }

    private RepositoryHookResult preUpdateRebaseDryRun(@Nonnull GitRebaseHookRequest request) {
        Branch branch = request.getBranch();
        if (this.canRebase(request.getRepository(), branch, request.getUpstream())) {
            return RepositoryHookResult.accepted();
        }
        return RepositoryHookResult.rejected((String)this.i18nService.getMessage("bitbucket.branch.permission.rebase.check.summary", new Object[0]), (String)this.i18nService.getMessage("bitbucket.branch.permission.rebase.check", new Object[]{branch.getDisplayId()}));
    }

    private /* synthetic */ Map lambda$preUpdate$0(RestrictionMatchRequest matchRequest) throws RuntimeException {
        return this.restrictionService.match(matchRequest);
    }
}

