/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.analytics;

import com.atlassian.analytics.api.annotations.EventName;
import com.atlassian.bitbucket.repository.ref.restriction.AccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.AccessKeyAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.GroupAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionUpdatedEvent;
import com.atlassian.bitbucket.repository.ref.restriction.UserAccessGrant;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.event.api.AsynchronousPreferred;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;

@AsynchronousPreferred
@EventName(value="stash.branch-permission.updated")
public class AnalyticsRefRestrictionUpdatedEvent
extends RefRestrictionUpdatedEvent {
    private final Integer affectedAccessKeys;
    private final Integer affectedGroups;
    private final Integer affectedUsers;

    public AnalyticsRefRestrictionUpdatedEvent(@Nonnull Object source, @Nonnull RefRestriction restriction, @Nonnull RefRestriction oldRestriction) {
        super(source, restriction, oldRestriction);
        List<AccessGrant> accessGrants = restriction.getAccessGrants();
        this.affectedAccessKeys = AnalyticsRefRestrictionUpdatedEvent.countOrNull(accessGrants.stream().filter(AccessKeyAccessGrant.class::isInstance).count());
        this.affectedGroups = AnalyticsRefRestrictionUpdatedEvent.countOrNull(accessGrants.stream().filter(GroupAccessGrant.class::isInstance).count());
        this.affectedUsers = AnalyticsRefRestrictionUpdatedEvent.countOrNull(accessGrants.stream().filter(UserAccessGrant.class::isInstance).count());
    }

    @Nullable
    public Integer getAffectedAccessKeyCount() {
        return this.affectedAccessKeys;
    }

    @Nullable
    public Integer getAffectedGroupCount() {
        return this.affectedGroups;
    }

    @Nullable
    public Integer getAffectedUserCount() {
        return this.affectedUsers;
    }

    @Nonnull
    public String getMatcherType() {
        return this.getRestriction().getMatcher().getType().getDisplayId();
    }

    @Nonnull
    public Integer getRestrictionId() {
        return this.getRestriction().getId();
    }

    @Nonnull
    public RefRestrictionType getRestrictionType() {
        return this.getRestriction().getType();
    }

    @Nonnull
    public Scope getScope() {
        return this.getRestriction().getScope();
    }

    private static Integer countOrNull(long val) {
        return val > 0L ? Integer.valueOf(Math.toIntExact(val)) : null;
    }
}

