/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.atst;

import com.atlassian.bitbucket.repository.ref.restriction.AccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.AccessGrantVisitor;
import com.atlassian.bitbucket.repository.ref.restriction.AccessKeyAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.GroupAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionService;
import com.atlassian.bitbucket.repository.ref.restriction.RestrictionSearchRequest;
import com.atlassian.bitbucket.repository.ref.restriction.UserAccessGrant;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.troubleshooting.spi.SupportDataBuilder;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;

public class RefRestrictionSupportDataHelper {
    private static final String PLUGINS_BRANCH_PERMISSIONS = "bitbucket.atst.branch.permissions";
    private static final String PLUGINS_BRANCH_PERMISSION = "bitbucket.atst.branch.permissions.permission";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANTS = "bitbucket.atst.branch.permissions.permission.access-grants";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY = "bitbucket.atst.branch.permissions.permission.access-grants.access.key";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEYS = "bitbucket.atst.branch.permissions.permission.access-grants.access.keys";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY_KEY = "bitbucket.atst.branch.permissions.permission.access-grants.access.key.key";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY_KEY_ID = "bitbucket.atst.branch.permissions.permission.access-grants.access.key.key.id";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY_KEY_LABEL = "bitbucket.atst.branch.permissions.permission.access-grants.access.key.key.label";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY_PERMISSION = "bitbucket.atst.branch.permissions.permission.access-grants.access.key.permission";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_GROUPS = "bitbucket.atst.branch.permissions.permission.access-grants.groups";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_GROUPS_GROUP = "bitbucket.atst.branch.permissions.permission.access-grants.group";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_USERS = "bitbucket.atst.branch.permissions.permission.access-grants.users";
    private static final String PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_USERS_USER = "bitbucket.atst.branch.permissions.permission.access-grants.users.user";
    private static final String PLUGINS_BRANCH_PERMISSION_MATCHER = "bitbucket.atst.branch.permissions.permission.matcher";
    private static final String PLUGINS_BRANCH_PERMISSION_MATCHER_ID = "bitbucket.atst.branch.permissions.permission.matcher.id";
    private static final String PLUGINS_BRANCH_PERMISSION_MATCHER_TYPE = "bitbucket.atst.branch.permissions.permission.matcher.type";
    private static final String PLUGINS_BRANCH_PERMISSION_NAME = "bitbucket.atst.branch.permissions.name";
    private static final String PLUGINS_BRANCH_PERMISSION_RESTRICTION_TYPE = "bitbucket.atst.branch.permissions.permission.type";
    private final RefRestrictionService refRestrictionService;

    public RefRestrictionSupportDataHelper(RefRestrictionService refRestrictionService) {
        this.refRestrictionService = refRestrictionService;
    }

    public void addBranchPermissionDetails(SupportDataBuilder builder, Scope scope) {
        RestrictionSearchRequest request = new RestrictionSearchRequest.Builder(scope).effective(false).build();
        Page<RefRestriction> restrictions = this.refRestrictionService.search(request, PageUtils.newRequest((int)0, (int)500));
        if (Iterables.isEmpty((Iterable)restrictions.getValues())) {
            return;
        }
        builder = builder.addCategory(PLUGINS_BRANCH_PERMISSIONS);
        for (RefRestriction ref : restrictions.getValues()) {
            SupportDataBuilder permissionBuilder = builder.addCategory(PLUGINS_BRANCH_PERMISSION);
            permissionBuilder.addValue(PLUGINS_BRANCH_PERMISSION_MATCHER_TYPE, ref.getMatcher().getType().getDisplayId());
            permissionBuilder.addValue(PLUGINS_BRANCH_PERMISSION_MATCHER_ID, ref.getMatcher().getId());
            permissionBuilder.addValue(PLUGINS_BRANCH_PERMISSION_RESTRICTION_TYPE, ref.getType().name());
            RefRestrictionSupportDataHelper.addAccessGrants(permissionBuilder, ref.getAccessGrants());
            permissionBuilder.addContext((Object)ref);
        }
    }

    private static void addAccessGrants(SupportDataBuilder permissionBuilder, Collection<AccessGrant> accessGrants) {
        if (accessGrants.isEmpty()) {
            return;
        }
        permissionBuilder = permissionBuilder.addCategory(PLUGINS_BRANCH_PERMISSION_ACCESS_GRANTS);
        final SupportDataBuilder groupBuilder = permissionBuilder.addCategory(PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_GROUPS);
        final SupportDataBuilder userBuilder = permissionBuilder.addCategory(PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_USERS);
        final SupportDataBuilder accessKeyBuilder = permissionBuilder.addCategory(PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEYS);
        AccessGrantVisitor<Void> builderVisitor = new AccessGrantVisitor<Void>(){

            @Override
            public Void visit(@Nonnull AccessKeyAccessGrant grant) {
                accessKeyBuilder.addCategory(RefRestrictionSupportDataHelper.PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY).addValue(RefRestrictionSupportDataHelper.PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY_PERMISSION, grant.getAccessKey().getPermission().name()).addCategory(RefRestrictionSupportDataHelper.PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY_KEY).addValue(RefRestrictionSupportDataHelper.PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY_KEY_ID, String.valueOf(grant.getAccessKey().getKey().getId())).addValue(RefRestrictionSupportDataHelper.PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_ACCESS_KEY_KEY_LABEL, grant.getAccessKey().getKey().getLabel());
                return null;
            }

            @Override
            public Void visit(@Nonnull GroupAccessGrant grant) {
                this.addValue(groupBuilder, RefRestrictionSupportDataHelper.PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_GROUPS_GROUP, grant.getGroup());
                return null;
            }

            @Override
            public Void visit(@Nonnull UserAccessGrant grant) {
                this.addValue(userBuilder, RefRestrictionSupportDataHelper.PLUGINS_BRANCH_PERMISSION_ACCESS_GRANT_USERS_USER, grant.getUser().getName());
                return null;
            }

            private void addValue(SupportDataBuilder builder, String categoryName, String value) {
                builder.addCategory(categoryName).addValue(RefRestrictionSupportDataHelper.PLUGINS_BRANCH_PERMISSION_NAME, value);
            }
        };
        for (AccessGrant accessGrant : accessGrants) {
            accessGrant.accept(builderVisitor);
        }
    }
}

