/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.audit;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.ChangedValue;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.ref.restriction.AccessGrantVisitor;
import com.atlassian.bitbucket.repository.ref.restriction.AccessKeyAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.GroupAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionAddedEvent;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionDeletedEvent;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionEvent;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionUpdatedEvent;
import com.atlassian.bitbucket.repository.ref.restriction.UserAccessGrant;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.util.AuditUtils;
import com.atlassian.event.api.EventListener;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class RefRestrictionEventListener {
    @VisibleForTesting
    static final String ACTION_PROJECT_ADDED_EVENT = "bitbucket.branch.permission.audit.action.projectrefrestrictionadded";
    @VisibleForTesting
    static final String ACTION_PROJECT_DELETED_EVENT = "bitbucket.branch.permission.audit.action.projectrefrestrictiondeleted";
    @VisibleForTesting
    static final String ACTION_PROJECT_UPDATED_EVENT = "bitbucket.branch.permission.audit.action.projectrefrestrictionupdated";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_ADDED_EVENT = "bitbucket.branch.permission.audit.action.repositoryrefrestrictionadded";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_DELETED_EVENT = "bitbucket.branch.permission.audit.action.repositoryrefrestrictiondeleted";
    @VisibleForTesting
    static final String ACTION_REPOSITORY_UPDATED_EVENT = "bitbucket.branch.permission.audit.action.repositoryrefrestrictionupdated";
    @VisibleForTesting
    static final String ATTR_ACCESS_KEY = "bitbucket.branch.permission.audit.attribute.refrestrictionevent.accesskeys";
    @VisibleForTesting
    static final String ATTR_GROUPS = "bitbucket.branch.permission.audit.attribute.refrestrictionevent.groups";
    @VisibleForTesting
    static final String ATTR_ID = "bitbucket.branch.permission.audit.attribute.refrestrictionevent.id";
    @VisibleForTesting
    static final String ATTR_MATCHER = "bitbucket.branch.permission.audit.attribute.refrestrictionevent.matcher";
    @VisibleForTesting
    static final String ATTR_MATCHER_TYPE = "bitbucket.branch.permission.audit.attribute.refrestrictionevent.matchertype";
    @VisibleForTesting
    static final String ATTR_TYPE = "bitbucket.branch.permission.audit.attribute.refrestrictionevent.type";
    @VisibleForTesting
    static final String ATTR_USERS = "bitbucket.branch.permission.audit.attribute.refrestrictionevent.users";
    private final AuditService auditService;

    public RefRestrictionEventListener(AuditService auditService) {
        this.auditService = auditService;
    }

    @EventListener
    public void onRefRestrictionAddedEvent(RefRestrictionAddedEvent event) {
        Map<String, List<String>> affectedGrants = RefRestrictionEventListener.getAffectedGrants(event.getRestriction());
        AuditEvent.Builder builder = RefRestrictionEventListener.auditRefRestrictionEvent(event, AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)ACTION_PROJECT_ADDED_EVENT).build()));
        this.auditService.audit(RefRestrictionEventListener.addExtraAttributes(affectedGrants, builder).build());
    }

    @EventListener
    public void onRefRestrictionDeletedEvent(RefRestrictionDeletedEvent event) {
        Map<String, List<String>> affectedGrants = RefRestrictionEventListener.getAffectedGrants(event.getRestriction());
        AuditEvent.Builder builder = RefRestrictionEventListener.auditRefRestrictionEvent(event, AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)ACTION_PROJECT_DELETED_EVENT).build()));
        this.auditService.audit(RefRestrictionEventListener.addExtraAttributes(affectedGrants, builder).build());
    }

    @EventListener
    public void onRefRestrictionUpdatedEvent(RefRestrictionUpdatedEvent event) {
        Map<String, List<String>> affectedGrants = RefRestrictionEventListener.getAffectedGrants(event.getRestriction());
        AuditEvent.Builder builder = RefRestrictionEventListener.auditRefRestrictionEvent(event, AuditEvent.builder((AuditType)AuditType.fromI18nKeys((CoverageArea)CoverageArea.LOCAL_CONFIG_AND_ADMINISTRATION, (CoverageLevel)CoverageLevel.BASE, (String)"bitbucket.service.audit.category.projects", (String)ACTION_PROJECT_UPDATED_EVENT).build()));
        RefRestriction oldRestriction = event.getOldRestriction();
        if (oldRestriction != null) {
            RefRestrictionEventListener.addChangedValues(affectedGrants, RefRestrictionEventListener.getAffectedGrants(oldRestriction), builder);
        }
        this.auditService.audit(builder.build());
    }

    private static void addChangedValues(Map<String, List<String>> newGrants, Map<String, List<String>> oldGrants, AuditEvent.Builder builder) {
        builder.addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_ACCESS_KEY).from(StringUtils.join((Iterable)oldGrants.get(ATTR_ACCESS_KEY), (String)", ")).to(StringUtils.join((Iterable)newGrants.get(ATTR_ACCESS_KEY), (String)", ")).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_USERS).from(StringUtils.join((Iterable)oldGrants.get(ATTR_USERS), (String)", ")).to(StringUtils.join((Iterable)newGrants.get(ATTR_USERS), (String)", ")).build()).addChangedValueIfDifferent(ChangedValue.fromI18nKeys((String)ATTR_GROUPS).from(StringUtils.join((Iterable)oldGrants.get(ATTR_GROUPS), (String)", ")).to(StringUtils.join((Iterable)newGrants.get(ATTR_GROUPS), (String)", ")).build());
    }

    private static AuditEvent.Builder addExtraAttributes(Map<String, List<String>> grants, AuditEvent.Builder builder) {
        if (grants.get(ATTR_ACCESS_KEY) != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ACCESS_KEY, (String)StringUtils.join((Iterable)grants.get(ATTR_ACCESS_KEY), (String)", ")).build());
        }
        if (grants.get(ATTR_GROUPS) != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_GROUPS, (String)StringUtils.join((Iterable)grants.get(ATTR_GROUPS), (String)", ")).build());
        }
        if (grants.get(ATTR_USERS) != null) {
            builder.extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_USERS, (String)StringUtils.join((Iterable)grants.get(ATTR_USERS), (String)", ")).build());
        }
        return builder;
    }

    private static AuditEvent.Builder auditRefRestrictionEvent(final RefRestrictionEvent event, final AuditEvent.Builder builder) {
        return ((AuditEvent.Builder)event.getRestriction().getScope().accept((ScopeVisitor)new ScopeVisitor<AuditEvent.Builder>(){

            public AuditEvent.Builder visit(@Nonnull GlobalScope scope) {
                return builder;
            }

            public AuditEvent.Builder visit(@Nonnull ProjectScope projectScope) {
                return builder.affectedObject(AuditUtils.auditResourceForProject((Project)projectScope.getProject()));
            }

            public AuditEvent.Builder visit(@Nonnull RepositoryScope repositoryScope) {
                return builder.actionI18nKey(RefRestrictionEventListener.toRepositoryActionI18nKey(event)).affectedObjects(AuditUtils.auditResourcesForProjectAndRepository((Repository)repositoryScope.getRepository())).categoryI18nKey("bitbucket.service.audit.category.repositories");
            }
        })).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_ID, (String)String.valueOf(event.getRestriction().getId())).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_TYPE, (String)event.getRestriction().getType().getId()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MATCHER, (String)event.getRestriction().getMatcher().getId()).build()).extraAttribute(AuditAttribute.fromI18nKeys((String)ATTR_MATCHER_TYPE, (String)event.getRestriction().getMatcher().getType().getDisplayId()).build());
    }

    private static Map<String, List<String>> getAffectedGrants(RefRestriction refRestriction) {
        final HashMap<String, List<String>> grants = new HashMap<String, List<String>>();
        AccessGrantVisitor<Void> listAddingVisitor = new AccessGrantVisitor<Void>(){

            @Override
            public Void visit(@Nonnull GroupAccessGrant grant) {
                grants.computeIfAbsent(RefRestrictionEventListener.ATTR_GROUPS, i -> new ArrayList()).add(grant.getGroup());
                return null;
            }

            @Override
            public Void visit(@Nonnull UserAccessGrant grant) {
                grants.computeIfAbsent(RefRestrictionEventListener.ATTR_USERS, i -> new ArrayList()).add(grant.getUser().getName());
                return null;
            }

            @Override
            public Void visit(@Nonnull AccessKeyAccessGrant grant) {
                grants.computeIfAbsent(RefRestrictionEventListener.ATTR_ACCESS_KEY, i -> new ArrayList()).add(String.valueOf(grant.getAccessKey().getKey().getId()));
                return null;
            }
        };
        refRestriction.getAccessGrants().forEach(accessGrant -> accessGrant.accept(listAddingVisitor));
        return grants;
    }

    private static String toRepositoryActionI18nKey(RefRestrictionEvent event) {
        if (event instanceof RefRestrictionAddedEvent) {
            return ACTION_REPOSITORY_ADDED_EVENT;
        }
        if (event instanceof RefRestrictionUpdatedEvent) {
            return ACTION_REPOSITORY_UPDATED_EVENT;
        }
        return ACTION_REPOSITORY_DELETED_EVENT;
    }
}

