/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherType;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.bitbucket.repository.ref.restriction.SetRestrictionRequest;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.crowd.embedded.impl.IdentifierUtils;
import com.atlassian.stash.internal.repository.ref.restriction.dao.AoAccessGrant;
import com.atlassian.stash.internal.repository.ref.restriction.dao.AoRefRestriction;
import com.atlassian.stash.internal.repository.ref.restriction.dao.RefRestrictionDao;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;

public class AoRefRestrictionDao
extends AbstractAoDao
implements RefRestrictionDao {
    public AoRefRestrictionDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public int count(@Nonnull Scope scope) {
        return scope.getResourceId().map(resourceId -> this.ao.count(AoRefRestriction.class, Query.select().where("RESOURCE_ID = ? AND SCOPE_TYPE = ?", new Object[]{resourceId, scope.getType()}))).orElse(0);
    }

    @Override
    @Nonnull
    public AoRefRestriction create(@Nonnull SetRestrictionRequest request) {
        RefRestrictionType refRestrictionType;
        RefMatcher refMatcher = request.getMatcher();
        Scope scope = request.getScope();
        AoRefRestriction existing = this.get(scope, refRestrictionType = request.getType(), request.getMatcher());
        if (existing != null) {
            throw new IllegalStateException("Ref restriction already exists (scope = " + String.valueOf(scope) + ", type = " + refRestrictionType.getId() + ", matcher = {" + refMatcher.getType().getId() + ", " + refMatcher.getId() + "})");
        }
        Integer resourceId = (Integer)scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Ref restriction cannot be created at scope type: " + String.valueOf(scope.getType())));
        AoRefRestriction restriction = (AoRefRestriction)this.ao.create(AoRefRestriction.class, (Map)ImmutableMap.of((Object)"RESOURCE_ID", (Object)resourceId, (Object)"SCOPE_TYPE", (Object)scope.getType(), (Object)"REF_TYPE", (Object)refMatcher.getType().getId(), (Object)"RESTRICTION_TYPE", (Object)refRestrictionType.getId(), (Object)"REF_VALUE", (Object)refMatcher.getId()));
        List<String> groups = request.getGroupGrants();
        List<ApplicationUser> users = request.getUserGrants();
        List<SshAccessKey> accessKeys = request.getAccessKeyGrants();
        if (groups.isEmpty() && users.isEmpty() && accessKeys.isEmpty()) {
            return restriction;
        }
        groups.forEach(group -> this.createAccessGrant(restriction, "GROUP_ID", group));
        users.forEach(user -> this.createAccessGrant(restriction, "USER_ID", user.getId()));
        accessKeys.forEach(accessKey -> this.createAccessGrant(restriction, "ACCESS_KEY_ID", accessKey.getKey().getId()));
        return (AoRefRestriction)this.ao.get(AoRefRestriction.class, (Object)restriction.getID());
    }

    @Override
    public void delete(@Nonnull AoRefRestriction restriction) {
        this.ao.delete((RawEntity[])restriction.getAccessGrants());
        this.ao.delete(new RawEntity[]{restriction});
    }

    @Override
    public void deleteForAccessKey(int accessKeyId) {
        this.ao.delete(this.ao.find(AoAccessGrant.class, Query.select().where("ACCESS_KEY_ID = ?", new Object[]{accessKeyId})));
    }

    @Override
    public void deleteForGroup(@Nonnull String group) {
        this.ao.delete(this.ao.find(AoAccessGrant.class, Query.select().where("LOWER(" + this.quoteColumnName("GROUP_ID") + ") =  ?", new Object[]{this.canonicalizeGroup(group)})));
    }

    @Override
    public void deleteForScope(@Nonnull Scope scope) {
        scope.getResourceId().ifPresent(resourceId -> {
            AoRefRestriction[] refRestrictions;
            for (AoRefRestriction restriction : refRestrictions = (AoRefRestriction[])this.ao.find(AoRefRestriction.class, Query.select().where("RESOURCE_ID = ? AND SCOPE_TYPE = ?", new Object[]{resourceId, scope.getType()}))) {
                this.delete(restriction);
            }
        });
    }

    @Override
    public void deleteForUser(int userId) {
        this.ao.delete(this.ao.find(AoAccessGrant.class, Query.select().where("USER_ID = ?", new Object[]{userId})));
    }

    @VisibleForTesting
    AoAccessGrant[] findGrantsByRestrictionId(int restrictionId) {
        AoRefRestriction restriction = this.getById(restrictionId);
        return restriction == null ? new AoAccessGrant[]{} : restriction.getAccessGrants();
    }

    @Override
    public AoRefRestriction get(@Nonnull Scope scope, @Nonnull RefRestrictionType refRestrictionType, @Nonnull RefMatcher matcher) {
        Integer resourceId = (Integer)scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Ref restriction cannot be managed at scope type: " + String.valueOf(scope.getType())));
        AoRefRestriction[] restrictions = (AoRefRestriction[])this.ao.find(AoRefRestriction.class, AoUtils.newQuery((String[])new String[]{"ID", "RESOURCE_ID", "SCOPE_TYPE", "RESTRICTION_TYPE", "REF_TYPE", "REF_VALUE"}).where("RESOURCE_ID = ? AND SCOPE_TYPE = ? AND RESTRICTION_TYPE = ? AND REF_TYPE = ? AND REF_VALUE = ? ", new Object[]{resourceId, scope.getType(), refRestrictionType.getId(), matcher.getType().getId(), matcher.getId()}).limit(1));
        return restrictions.length > 0 ? restrictions[0] : null;
    }

    @Override
    @Nonnull
    public AoRefRestriction setAccessGrants(@Nonnull AoRefRestriction restriction, @Nonnull Iterable<String> groups, @Nonnull Iterable<Integer> userIds, @Nonnull Iterable<Integer> accessKeyIds) {
        HashSet accessKeysToAdd = new HashSet();
        HashSet groupsToAdd = new HashSet();
        HashSet usersToAdd = new HashSet();
        groups.forEach(groupsToAdd::add);
        userIds.forEach(usersToAdd::add);
        accessKeyIds.forEach(accessKeysToAdd::add);
        boolean grantsUpdated = false;
        for (AoAccessGrant grant : restriction.getAccessGrants()) {
            if (grant.getUserId() != null && !usersToAdd.remove(grant.getUserId())) {
                this.ao.delete(new RawEntity[]{grant});
                grantsUpdated = true;
                continue;
            }
            if (grant.getGroup() != null && !groupsToAdd.remove(grant.getGroup())) {
                this.ao.delete(new RawEntity[]{grant});
                grantsUpdated = true;
                continue;
            }
            if (grant.getAccessKeyId() == null || accessKeysToAdd.remove(grant.getAccessKeyId())) continue;
            this.ao.delete(new RawEntity[]{grant});
            grantsUpdated = true;
        }
        groupsToAdd.forEach(group -> this.createAccessGrant(restriction, "GROUP_ID", group));
        usersToAdd.forEach(userId -> this.createAccessGrant(restriction, "USER_ID", userId));
        accessKeysToAdd.forEach(accessKeyId -> this.createAccessGrant(restriction, "ACCESS_KEY_ID", accessKeyId));
        return (grantsUpdated |= !groupsToAdd.isEmpty() || !usersToAdd.isEmpty() || !accessKeysToAdd.isEmpty()) ? (AoRefRestriction)this.ao.get(AoRefRestriction.class, (Object)restriction.getID()) : restriction;
    }

    @Override
    public AoRefRestriction getById(int restrictionId) {
        return (AoRefRestriction)this.ao.get(AoRefRestriction.class, (Object)restrictionId);
    }

    @Override
    @Nonnull
    public Page<AoRefRestriction> find(@Nonnull Collection<Scope> scopes, @Nullable Collection<RefRestrictionType> types, @Nullable RefMatcher matcher, @Nullable Collection<? extends RefMatcherType> matcherTypes, @Nonnull PageRequest pageRequest) {
        ArrayList whereArguments = Lists.newArrayList();
        ArrayList whereClauses = Lists.newArrayList();
        scopes.stream().forEach(scope -> {
            whereClauses.add("( RESOURCE_ID = ? AND SCOPE_TYPE = ? )");
            whereArguments.add(scope.getResourceId().orElseThrow(() -> new UnsupportedOperationException("Ref restriction cannot be searched at scope type: " + String.valueOf(scope.getType()))));
            whereArguments.add(scope.getType());
        });
        StringBuilder whereClause = new StringBuilder("( " + StringUtils.join((Iterable)whereClauses, (String)" OR ") + " )");
        this.maybeAddTypeClause(whereClause, whereArguments, types);
        this.maybeAddMatcherClause(whereClause, whereArguments, matcher);
        this.maybeAddMatcherTypeClause(whereClause, whereArguments, matcherTypes);
        Query query = Query.select().where(whereClause.toString(), whereArguments.toArray()).order(this.getOrderBy());
        return this.pageQuery(AoRefRestriction.class, query, pageRequest);
    }

    private AoAccessGrant createAccessGrant(AoRefRestriction restriction, String column, Object groupOrUser) {
        AoAccessGrant grant = (AoAccessGrant)this.ao.create(AoAccessGrant.class, (Map)ImmutableMap.of((Object)"FK_RESTRICTED_ID", (Object)restriction.getID(), (Object)column, (Object)groupOrUser));
        grant.setRestriction(restriction);
        grant.save();
        return grant;
    }

    private boolean maybeAddMatcherClause(StringBuilder whereClause, List<Object> arguments, RefMatcher matcher) {
        if (matcher == null) {
            return false;
        }
        whereClause.append(" AND ").append("REF_TYPE").append(" = ? AND ").append("REF_VALUE").append(" = ?");
        arguments.add(matcher.getType().getId());
        arguments.add(matcher.getId());
        return true;
    }

    private boolean maybeAddMatcherTypeClause(StringBuilder whereClause, List<Object> arguments, Collection<? extends RefMatcherType> matcherTypes) {
        if (matcherTypes == null || matcherTypes.isEmpty()) {
            return false;
        }
        int i = 0;
        for (RefMatcherType refMatcherType : matcherTypes) {
            whereClause.append(i == 0 ? " AND " : " OR ").append("REF_TYPE").append(" = ? ");
            arguments.add(refMatcherType.getId());
            ++i;
        }
        return i > 0;
    }

    private boolean maybeAddTypeClause(StringBuilder whereClause, List<Object> arguments, Collection<RefRestrictionType> types) {
        if (types == null || types.isEmpty()) {
            return false;
        }
        whereClause.append(" AND ").append("RESTRICTION_TYPE").append(" IN (").append(this.inClausePlaceholder(types)).append(")");
        arguments.addAll(Chainable.chain(types).transform(RefRestrictionType::getId).toList());
        return true;
    }

    private String inClausePlaceholder(Iterable<?> values) {
        return Joiner.on((String)", ").join(Iterables.transform(values, (Function)Functions.constant((Object)"?")));
    }

    private String canonicalizeGroup(String group) {
        return IdentifierUtils.toLowerCase((String)group);
    }

    private String getOrderBy() {
        return "REF_TYPE, REF_VALUE, RESTRICTION_TYPE, SCOPE_TYPE ASC";
    }
}

