/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.stash.internal.repository.ref.restriction.dao.v0.AoPermittedEntityV0;
import com.atlassian.stash.internal.repository.ref.restriction.dao.v0.AoRestrictedRefV0;
import com.google.common.base.Preconditions;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.Table;

public class MigrateToV1Task
implements ActiveObjectsUpgradeTask {
    private static final int PAGE_SIZE = 500;

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, final ActiveObjects ao) {
        boolean fullPageRetrieved;
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This task can only upgrade from version 0 to 1");
        ao.migrateDestructively(new Class[]{AoRefRestrictionV0ToV1.class, AoPermittedEntityV0.class});
        while (fullPageRetrieved = ((Boolean)ao.executeInTransaction((TransactionCallback)new TransactionCallback<Boolean>(){

            public Boolean doInTransaction() {
                AoRefRestrictionV0ToV1[] restrictions;
                for (AoRefRestrictionV0ToV1 restriction : restrictions = (AoRefRestrictionV0ToV1[])ao.find(AoRefRestrictionV0ToV1.class, Query.select().where("RESTRICTION_TYPE IS null ", new Object[0]).limit(500))) {
                    restriction.setRestrictionType(RefRestrictionType.READ_ONLY.getId());
                    restriction.save();
                }
                return restrictions.length == 500;
            }
        })).booleanValue()) {
        }
    }

    @Table(value="RESTRICTED_REF")
    @Preload
    public static interface AoRefRestrictionV0ToV1
    extends AoRestrictedRefV0 {
        public static final String RESTRICTION_TYPE_COLUMN = "RESTRICTION_TYPE";

        @Accessor(value="RESTRICTION_TYPE")
        @Indexed
        public String getRestrictionType();

        @Mutator(value="RESTRICTION_TYPE")
        public void setRestrictionType(String var1);
    }
}

