/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.dao.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.ao.AoUtils;
import com.atlassian.bitbucket.scope.ScopeType;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.PagedIterable;
import com.atlassian.stash.internal.repository.ref.restriction.dao.AoAccessGrant;
import com.atlassian.stash.internal.repository.ref.restriction.dao.AoRefRestriction;
import com.atlassian.stash.internal.repository.ref.restriction.dao.v1.AoRefRestrictionV1;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import net.java.ao.Accessor;
import net.java.ao.Mutator;
import net.java.ao.Preload;
import net.java.ao.Query;
import net.java.ao.schema.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV2Task
implements ActiveObjectsUpgradeTask {
    private static final int PAGE_SIZE = 500;
    private static final Logger log = LoggerFactory.getLogger(MigrateToV2Task.class);
    private static final Query REF_RESTRICTION_QUERY = Query.select().order("REF_ID");
    private final int pageSize;

    public MigrateToV2Task() {
        this.pageSize = 500;
    }

    MigrateToV2Task(int pageSize) {
        this.pageSize = pageSize;
    }

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"1")), (Object)"This task can only upgrade from version 1 to 2");
        log.info("Migrating ref restrictions to version 2");
        ao.migrate(new Class[]{AoRefRestrictionV1ToV2.class});
        PagedIterable refRestrictions = new PagedIterable(request -> PageUtils.createPage(Arrays.asList((AoRefRestrictionV1ToV2[])ao.find(AoRefRestrictionV1ToV2.class, AoUtils.restrict((Query)REF_RESTRICTION_QUERY, (PageRequest)request))), (PageRequest)request), this.pageSize);
        refRestrictions.forEach(restriction -> {
            log.trace("Migrating ref restriction with ID {}", (Object)restriction.getId());
            restriction.setScopeType(ScopeType.REPOSITORY);
            restriction.setResourceId(restriction.getRepositoryId());
            restriction.save();
            log.trace("Migration complete for ref restriction with ID {}", (Object)restriction.getId());
        });
        ao.migrateDestructively(new Class[]{AoRefRestriction.class, AoAccessGrant.class});
        log.info("Ref restriction migration to version 2 complete.");
    }

    @Table(value="RESTRICTED_REF")
    @Preload
    public static interface AoRefRestrictionV1ToV2
    extends AoRefRestrictionV1 {
        @Accessor(value="RESOURCE_ID")
        public Integer getResourceId();

        @Accessor(value="SCOPE_TYPE")
        public ScopeType getScopeType();

        @Mutator(value="RESOURCE_ID")
        public void setResourceId(Integer var1);

        @Mutator(value="SCOPE_TYPE")
        public void setScopeType(ScopeType var1);
    }
}

