/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.provider;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.ref.restriction.AbstractRefMatcher;
import com.atlassian.bitbucket.scm.git.GitRefPattern;
import com.atlassian.stash.internal.repository.ref.restriction.provider.BranchRestrictionType;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.function.BiFunction;
import org.apache.commons.lang3.StringUtils;

public class BranchMatcher
extends AbstractRefMatcher {
    private final boolean caseInsensitive;
    private final Supplier<MinimalRef> refResolver;

    public BranchMatcher(String refName, boolean caseInsensitive, Supplier<MinimalRef> refResolver) {
        super(BranchRestrictionType.getInstance(), refName);
        this.caseInsensitive = caseInsensitive;
        this.refResolver = Suppliers.memoize(refResolver);
    }

    @Override
    public boolean isActive() {
        return this.refResolver.get() != null;
    }

    @Override
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    @Nonnull
    public String getDisplayId() {
        MinimalRef resolved = (MinimalRef)this.refResolver.get();
        return resolved != null ? resolved.getDisplayId() : this.getId();
    }

    @Override
    public boolean matches(@Nonnull MinimalRef ref) {
        BiFunction<String, String, Boolean> equalsFunction = this.caseInsensitive ? StringUtils::equalsIgnoreCase : StringUtils::equals;
        String id = this.getId();
        String refId = Objects.requireNonNull(ref, "ref").getId();
        return equalsFunction.apply(id, refId) != false || equalsFunction.apply(GitRefPattern.HEADS.qualify(id), refId) != false;
    }
}

