/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.provider;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.SimpleMinimalRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherType;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.stash.internal.repository.ref.restriction.provider.BranchMatcher;
import com.atlassian.stash.internal.repository.ref.restriction.provider.BranchRestrictionType;
import com.google.common.base.Supplier;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class BranchMatcherProvider
implements RefMatcherProvider {
    private final boolean caseInsensitive;
    private final RefService refService;

    public BranchMatcherProvider(ApplicationPropertiesService propertiesService, RefService refService) {
        this.refService = refService;
        this.caseInsensitive = propertiesService.getPluginProperty("plugin.bitbucket-ref-restriction.case.insensitive", true);
    }

    @Override
    @Nonnull
    public Optional<RefMatcher> create(@Nonnull Scope scope, final @Nonnull String value) {
        Objects.requireNonNull(scope, "scope");
        return (Optional)scope.accept((ScopeVisitor)new ScopeVisitor<Optional<RefMatcher>>(){

            public Optional<RefMatcher> visit(@Nonnull GlobalScope scope) {
                return Optional.empty();
            }

            public Optional<RefMatcher> visit(@Nonnull ProjectScope scope) {
                return Optional.of(new BranchMatcher(value, BranchMatcherProvider.this.caseInsensitive, (Supplier<MinimalRef>)((Supplier)() -> ((SimpleMinimalRef.Builder)new SimpleMinimalRef.Builder().displayId(value)).type((RefType)StandardRefType.BRANCH).build())));
            }

            public Optional<RefMatcher> visit(@Nonnull RepositoryScope scope) {
                return Optional.of(new BranchMatcher(value, BranchMatcherProvider.this.caseInsensitive, (Supplier<MinimalRef>)((Supplier)() -> BranchMatcherProvider.this.refService.resolveRef(new ResolveRefRequest.Builder(scope.getRepository()).refId(value).type((RefType)StandardRefType.BRANCH).build()))));
            }
        });
    }

    @Override
    @Nonnull
    public RefMatcherType getType() {
        return BranchRestrictionType.getInstance();
    }
}

