/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.provider;

import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.ref.restriction.AbstractRefMatcher;
import com.atlassian.stash.internal.repository.ref.restriction.provider.PatternRestrictionType;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import org.springframework.util.AntPathMatcher;

public class PatternMatcher
extends AbstractRefMatcher {
    private AntPathMatcher matcher;
    private final boolean caseInsensitive;

    public PatternMatcher(String pattern, boolean caseInsensitive) {
        super(PatternRestrictionType.getInstance(), pattern);
        this.caseInsensitive = caseInsensitive;
    }

    @Override
    public boolean isCaseInsensitive() {
        return this.caseInsensitive;
    }

    @Override
    public boolean matches(@Nonnull MinimalRef ref) {
        String refId = ref.getId();
        Object pattern = this.getId();
        if (this.isCaseInsensitive()) {
            refId = refId.toLowerCase(Locale.US);
            pattern = ((String)pattern).toLowerCase(Locale.US);
        }
        if (!((String)pattern).startsWith("**") && !((String)pattern).startsWith("refs/")) {
            pattern = "**/" + (String)pattern;
        }
        if (((String)pattern).endsWith("/") || ((String)pattern).endsWith("\\")) {
            pattern = (String)pattern + "**";
        }
        return this.getPathMatcher().match((String)pattern, refId);
    }

    private AntPathMatcher getPathMatcher() {
        if (this.matcher == null) {
            this.matcher = new AntPathMatcher();
        }
        return this.matcher;
    }
}

