/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.ScopeResolver;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.repository.ref.restriction.rest.RefRestrictionResourceHelper;
import com.atlassian.stash.internal.repository.ref.restriction.rest.RestRefRestriction;
import com.atlassian.stash.internal.repository.ref.restriction.rest.RestRestrictionRequest;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.List;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/restrictions")
@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@Tag(name="Repository")
public class RefRestrictionRepositoryResource {
    private final RefRestrictionResourceHelper helper;

    @Inject
    public RefRestrictionRepositoryResource(RefRestrictionResourceHelper helper) {
        this.helper = helper;
    }

    @Operation(description="Create a restriction for the supplied branch or set of branches to be applied on all repositories in the given project.\n\nA restriction means preventing writes on the specified branch(es) by all except a set of users and/or groups, or preventing specific operations such as branch deletion.\n\nFor example, you can restrict write access on 'master' to just the 'senior-developer' group, or prevent anyone from deleting that branch.\n\nThe request matcher and type must conform to the following.\n\n- The matcher can be one of the following types\n   - 'BRANCH' represents a specific Branch name. You must supply the fully qualified name of the ref to restrict, e.g. \"refs/heads/master\"       instead of \"master\".\n   - 'PATTERN' represents a wildcard pattern that may match multiple branches. You must specify a valid       <a href=\"https://confluence.atlassian.com/display/STASH/Branch+permission+patterns\">Branch Permission Pattern</a>.\n   - 'MODEL_CATEGORY' represents Branch prefixes in the Branching model for the project. The 'id' must be one of\n       - 'FEATURE'\n       - 'BUGFIX'\n       - 'HOTFIX'\n       - 'RELEASE'\n\n\nSee the Branch REST API for more information.\n   - 'MODEL_BRANCH' represents either the Development or Production branch in the branching model for the project. The 'id' must be one of\n       - 'development'\n       - 'production'\n\n\nSee the Branch REST API for more information.\n- Type: Set and be one of <ul>- 'pull-request-only'\n- 'fast-forward-only'\n- 'no-deletes'\n- 'read-only'\n- 'no-creates'\n\n\nThe authenticated user must have <strong>PROJECT_ADMIN</strong> permission or higher to call this resource. Only authenticated users may call this resource.", summary="Create a ref restriction")
    @ResponseDocs(value={@ResponseDoc(documentation="Response contains the ref restriction that was just created.", responseCode=200, representation=RestRefRestriction.class), @ResponseDoc(documentation="The request has failed validation.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to perform this operation.", responseCode=401, restError=true)})
    @RequestBody(description="The request containing the details of the restriction to create.", content={@Content(schema=@Schema(implementation=RestRestrictionRequest.class))})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createRestriction(@BeanParam ScopeResolver scopeResolver, RestRestrictionRequest request) {
        return this.helper.createRestriction(scopeResolver.getScope(), request);
    }

    @Operation(description="Allows creating multiple restrictions at once.", summary="Create multiple ref restrictions")
    @RequestBody(description="The request containing a list of the details of the restrictions to create.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestRestrictionRequest.class)))})
    @ApiResponses(value={@ApiResponse(description="The list of ref restrictions that were just created.", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RestRefRestriction.class)))}, responseCode="200"), @ApiResponse(description="The request has failed validation.", content={@Content(schema=@Schema(implementation=RestErrors.class))}, responseCode="400"), @ApiResponse(description="The currently authenticated user has insufficient permissions to perform this operation.", content={@Content(schema=@Schema(implementation=RestErrors.class))}, responseCode="401")})
    @Consumes(value={"application/vnd.atl.bitbucket.bulk+json"})
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createRestrictions(@BeanParam ScopeResolver scopeResolver, List<RestRestrictionRequest> restrictions) {
        return this.helper.createRestrictions(scopeResolver.getScope(), restrictions);
    }

    @Operation(description="Deletes a restriction as specified by a restriction id.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission or higher to call this resource. Only authenticated users may call this resource.", summary="Delete a ref restriction")
    @Parameters(value={@Parameter(description="The restriction id.", in=ParameterIn.PATH, name="id")})
    @Path(value="{id}")
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the operation was successful", responseCode=204), @ResponseDoc(documentation="The request has failed validation.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user is not permitted to delete restrictions on the provided project", responseCode=401, restError=true)})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteRestriction(@PathParam(value="id") int id) {
        return this.helper.deleteRestriction(id);
    }

    @Operation(description="Returns a restriction as specified by a restriction id. \n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission or higher to call this resource. Only authenticated users may call this resource.", summary="Get a ref restriction")
    @Parameters(value={@Parameter(description="The restriction id.", in=ParameterIn.PATH, name="id")})
    @Path(value="{id}")
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing the restriction.", responseCode=200, representation=RestRefRestriction.class), @ResponseDoc(documentation="The request has failed validation.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user is not permitted to get restrictions on the provided project", responseCode=401, restError=true), @ResponseDoc(documentation="No restriction exists for the provided ID.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRestriction(@PathParam(value="id") int id) {
        return this.helper.getRestriction(id);
    }

    @Operation(description="Search for restrictions using the supplied parameters.\n\nThe authenticated user must have <strong>REPO_ADMIN</strong> permission or higher to call this resource. Only authenticated users may call this resource.", summary="Search for ref restrictions")
    @Parameters(value={@Parameter(name="type", in=ParameterIn.QUERY, schema=@Schema(allowableValues={"read-only", "no-deletes", "fast-forward-only", "pull-request-only", "no-creates"}, implementation=String.class), description="Types of restrictions to filter on."), @Parameter(name="matcherType", in=ParameterIn.QUERY, schema=@Schema(allowableValues={"BRANCH", "PATTERN", "MODEL_CATEGORY", "MODEL_BRANCH"}, implementation=String.class), description="Matcher type to filter on"), @Parameter(name="matcherId", in=ParameterIn.QUERY, description="Matcher id to filter on. Requires the matcherType parameter to be specified also.")})
    @ResponseDocs(value={@ResponseDoc(documentation="A response containing a page of restrictions.", paged=true, representation=RestRefRestriction.class, responseCode=200), @ResponseDoc(documentation="The request has failed validation.", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user is not permitted to get restrictions on the provided project", responseCode=401, restError=true), @ResponseDoc(documentation="No restriction exists for the provided ID.", responseCode=404, restError=true)})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getRestrictions(@BeanParam ScopeResolver scopeResolver, @QueryParam(value="type") List<String> typeStrings, @QueryParam(value="matcherType") String matcherType, @QueryParam(value="matcherId") String matcherId, @BeanParam PageRequestResolver pageRequestResolver) {
        return this.helper.getRestrictions(scopeResolver.getScope(), typeStrings, matcherType, matcherId, pageRequestResolver.getPageRequest());
    }
}

