/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.rest;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProviderRegistry;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherType;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionService;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestrictionType;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RestrictionSearchRequest;
import com.atlassian.bitbucket.repository.ref.restriction.SetRestrictionRequest;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.scm.git.command.GitRefCommandFactory;
import com.atlassian.bitbucket.scm.git.ref.GitValidateRefCommandParameters;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshAccessKeyService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.stash.internal.repository.ref.restriction.provider.BranchRestrictionType;
import com.atlassian.stash.internal.repository.ref.restriction.provider.PatternRestrictionType;
import com.atlassian.stash.internal.repository.ref.restriction.rest.RestRefRestriction;
import com.atlassian.stash.internal.repository.ref.restriction.rest.RestRestrictionRequest;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import jakarta.annotation.Nonnull;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class RefRestrictionResourceHelper {
    @VisibleForTesting
    static final String GROUP_INVALID = "bitbucket.rest.restricted.ref.group.invalid";
    @VisibleForTesting
    static final String INVALID_ACCESS_KEY = "bitbucket.rest.restricted.ref.accesskey.invalid";
    @VisibleForTesting
    static final String INVALID_MATCHER_TYPE = "bitbucket.rest.restricted.ref.invalid.matcher.type";
    @VisibleForTesting
    static final String INVALID_RESTRICTION_TYPE = "bitbucket.rest.restricted.ref.type.invalid";
    @VisibleForTesting
    static final String INVALID_USER = "bitbucket.rest.restricted.ref.user.invalid";
    @VisibleForTesting
    static final String MATCHER_REQUIRED = "bitbucket.rest.restricted.ref.matcher.required";
    @VisibleForTesting
    static final String MISMATCH_MATCHER_ID_TYPE = "bitbucket.rest.restricted.ref.matcher.id.type.mismatch";
    @VisibleForTesting
    static final String RESTRICTION_NOTFOUND = "bitbucket.rest.restricted.ref.notfound";
    @VisibleForTesting
    static final String UNSUPPORTED_RESTRICTION_TYPE_FOR_MATCHER = "bitbucket.rest.restricted.ref.type.unsupported.matcher";
    private static final String MATCHER_ID = "matcher.id";
    private static final String MATCHER_ID_INVALID_LENGTH = "bitbucket.rest.restricted.ref.matcher.id.length";
    private static final String MATCHER_ID_REQUIRED = "bitbucket.rest.restricted.ref.matcher.id.required";
    private static final String MATCHER_TYPE_ID = "matcher.type.id";
    private static final String MATCHER_TYPE_REQUIRED = "bitbucket.rest.restricted.ref.matcher.type.required";
    private static final String SCOPE_INVALID = "bitbucket.rest.restricted.ref.scope.invalid";
    private static final String SCOPE_TYPE = "scope.type";
    private static final String USER_UNLICENSED = "bitbucket.rest.restricted.ref.user.unlicensed";
    private final GitRefCommandFactory gitRefCommandFactory;
    private final I18nService i18nService;
    private final PermissionService permissionService;
    private final Predicate<ApplicationUser> isLicensed = new Predicate<ApplicationUser>(){

        @Override
        public boolean test(ApplicationUser user) {
            return RefRestrictionResourceHelper.this.permissionService.hasGlobalPermission(user, Permission.LICENSED_USER);
        }
    };
    private final RefMatcherProviderRegistry refMatcherProviderRegistry;
    private final RefRestrictionService restrictionService;
    private final SshAccessKeyService sshAccessKeyService;
    private final UserService userService;

    public RefRestrictionResourceHelper(GitRefCommandFactory gitRefCommandFactory, I18nService i18nService, PermissionService permissionService, RefRestrictionService restrictionService, RefMatcherProviderRegistry refMatcherProviderRegistry, SshAccessKeyService sshAccessKeyService, UserService userService) {
        this.gitRefCommandFactory = gitRefCommandFactory;
        this.i18nService = i18nService;
        this.permissionService = permissionService;
        this.restrictionService = restrictionService;
        this.refMatcherProviderRegistry = refMatcherProviderRegistry;
        this.sshAccessKeyService = sshAccessKeyService;
        this.userService = userService;
    }

    public Response createRestriction(@Context Scope scope, RestRestrictionRequest request) {
        ArrayList<RestErrorMessage> errors = new ArrayList<RestErrorMessage>();
        SetRestrictionRequest setRestrictionRequest = this.validateRestrictionRequest(scope, request, errors);
        if (!errors.isEmpty()) {
            RestErrors restErrors = new RestErrors(errors);
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)restErrors).build();
        }
        RefRestriction restriction = this.restrictionService.setRestriction(setRestrictionRequest);
        return ResponseFactory.ok().entity((Object)new RestRefRestriction(restriction)).build();
    }

    public Response createRestrictions(@Context Scope scope, List<RestRestrictionRequest> restrictions) {
        ArrayList<SetRestrictionRequest> restrictionRequests = new ArrayList<SetRestrictionRequest>();
        ArrayList errors = new ArrayList();
        restrictionRequests.addAll(restrictions.stream().map(restriction -> this.validateRestrictionRequest(scope, (RestRestrictionRequest)((Object)restriction), errors)).collect(Collectors.toList()));
        if (!errors.isEmpty()) {
            RestErrors restErrors = new RestErrors(errors);
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)restErrors).build();
        }
        List<RefRestriction> restrictionList = this.restrictionService.setRestrictions(restrictionRequests);
        List restRefRestrictions = restrictionList.stream().map(RestRefRestriction::new).collect(Collectors.toList());
        return ResponseFactory.ok().entity(restRefRestrictions).build();
    }

    public Response deleteRestriction(@PathParam(value="id") int id) {
        this.restrictionService.removeRefRestriction(id);
        return ResponseFactory.noContent().build();
    }

    public Response getRestriction(@PathParam(value="id") int id) {
        RefRestriction restriction = this.restrictionService.getById(id);
        if (restriction == null) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage(RESTRICTION_NOTFOUND, new Object[]{id}));
        }
        return ResponseFactory.ok().entity((Object)new RestRefRestriction(restriction)).build();
    }

    public Response getRestrictions(@Context Scope scope, @QueryParam(value="type") List<String> typeStrings, @QueryParam(value="matcherType") String matcherType, @QueryParam(value="matcherId") String matcherId, @Context PageRequest pageRequest) {
        RefMatcherType refMatcherType;
        ArrayList<RestErrorMessage> errors = new ArrayList<RestErrorMessage>();
        Set<RefRestrictionType> restrictionTypes = this.validateTypes(typeStrings, errors);
        RefMatcher matcher = StringUtils.isBlank((CharSequence)matcherId) ? null : this.validateMatcher(scope, matcherType, matcherId, errors);
        RefMatcherType refMatcherType2 = refMatcherType = StringUtils.isBlank((CharSequence)matcherType) ? null : this.validateMatcherType(matcherType, errors);
        if (!errors.isEmpty()) {
            RestErrors restErrors = new RestErrors(errors);
            return ResponseFactory.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)restErrors).build();
        }
        RestrictionSearchRequest.Builder builder = (RestrictionSearchRequest.Builder)((Object)new RestrictionSearchRequest.Builder(scope).types(restrictionTypes));
        if (matcher != null) {
            builder.matcher(matcher);
        } else if (refMatcherType != null) {
            builder.matcherType(refMatcherType);
        }
        Page<RefRestriction> restrictions = this.restrictionService.search(builder.build(), pageRequest);
        return ResponseFactory.ok((Object)new RestPage(restrictions, RestRefRestriction::new)).build();
    }

    private Set<SshAccessKey> validateAccessKeys(Collection<Integer> accessKeyIds, Scope scope, List<RestErrorMessage> errors) {
        HashSet<SshAccessKey> accessKeys = new HashSet<SshAccessKey>();
        for (final Integer accessKeyId : accessKeyIds) {
            SshAccessKey sshAccessKey = (SshAccessKey)scope.accept((ScopeVisitor)new ScopeVisitor<SshAccessKey>(){

                public SshAccessKey visit(@Nonnull ProjectScope scope) {
                    return RefRestrictionResourceHelper.this.sshAccessKeyService.getByKeyAndProject(accessKeyId.intValue(), scope.getProject()).orElse(null);
                }

                public SshAccessKey visit(@Nonnull RepositoryScope scope) {
                    return RefRestrictionResourceHelper.this.sshAccessKeyService.getByKeyAndRepository(accessKeyId.intValue(), scope.getRepository()).orElseGet(() -> RefRestrictionResourceHelper.this.sshAccessKeyService.getByKeyAndProject(accessKeyId.intValue(), scope.getRepository().getProject()).orElse(null));
                }
            });
            if (sshAccessKey == null) {
                errors.add(new RestErrorMessage("accessKeys", this.i18nService.getMessage(INVALID_ACCESS_KEY, new Object[]{accessKeyId})));
                continue;
            }
            accessKeys.add(sshAccessKey);
        }
        return accessKeys;
    }

    private Set<String> validateGroups(Collection<String> groups, List<RestErrorMessage> errors) {
        for (String group : groups) {
            if (this.userService.existsGroup(group)) continue;
            errors.add(new RestErrorMessage("groups", this.i18nService.getMessage(GROUP_INVALID, new Object[]{group})));
        }
        return new LinkedHashSet<String>(groups);
    }

    private RefMatcher validateMatcher(Scope scope, String type, String value, List<RestErrorMessage> errors) {
        if (StringUtils.isBlank((CharSequence)value)) {
            errors.add(new RestErrorMessage(MATCHER_ID, this.i18nService.getMessage(MATCHER_ID_REQUIRED, new Object[0])));
            return null;
        }
        if (StringUtils.isBlank((CharSequence)type)) {
            errors.add(new RestErrorMessage(MATCHER_TYPE_ID, this.i18nService.getMessage(MATCHER_TYPE_REQUIRED, new Object[0])));
            return null;
        }
        RefMatcherProvider provider = this.refMatcherProviderRegistry.getProvider(type);
        if (provider == null || type.length() > 255) {
            errors.add(new RestErrorMessage(MATCHER_TYPE_ID, this.i18nService.getMessage(INVALID_MATCHER_TYPE, new Object[]{type})));
            return null;
        }
        if (value.length() > 255) {
            errors.add(new RestErrorMessage(MATCHER_ID, this.i18nService.getMessage(MATCHER_ID_INVALID_LENGTH, new Object[]{255, value.length()})));
        }
        if (BranchRestrictionType.getInstance().equals(provider.getType())) {
            try {
                this.gitRefCommandFactory.validateRef(new GitValidateRefCommandParameters.Builder(value).build()).call();
            }
            catch (InvalidRefNameException e) {
                errors.add(new RestErrorMessage(MATCHER_ID, e.getLocalizedMessage()));
            }
        }
        if (PatternRestrictionType.getInstance().equals(provider.getType()) && CharMatcher.whitespace().matchesAnyOf((CharSequence)value)) {
            errors.add(new RestErrorMessage(MATCHER_ID, this.i18nService.getMessage("bitbucket.rest.restricted.ref.matcher.id.pattern.whitespace", new Object[0])));
            return null;
        }
        Optional<RefMatcher> refMatcher = provider.create(scope, value);
        if (refMatcher.isPresent()) {
            if (!provider.getType().equals(refMatcher.get().getType())) {
                errors.add(new RestErrorMessage(MATCHER_ID, this.i18nService.getMessage(MISMATCH_MATCHER_ID_TYPE, new Object[]{value, type})));
                return null;
            }
            return refMatcher.get();
        }
        errors.add(new RestErrorMessage(SCOPE_TYPE, this.i18nService.getMessage(SCOPE_INVALID, new Object[0])));
        return null;
    }

    private RefMatcher validateMatcher(Scope scope, RestRefMatcher matcher, List<RestErrorMessage> errors) {
        if (matcher == null) {
            errors.add(new RestErrorMessage(MATCHER_REQUIRED, this.i18nService.getMessage(MATCHER_REQUIRED, new Object[0])));
            return null;
        }
        return this.validateMatcher(scope, matcher.getType().getId(), matcher.getId(), errors);
    }

    private void validateMatcherAndTypeCombination(RefMatcher matcher, RefRestrictionType type, List<RestErrorMessage> errors) {
        if (matcher != null && type != null && BranchRestrictionType.getInstance().equals(matcher.getType()) && type == RefRestrictionType.NO_CREATES) {
            errors.add(new RestErrorMessage("type", this.i18nService.getMessage(UNSUPPORTED_RESTRICTION_TYPE_FOR_MATCHER, new Object[]{type.getId(), matcher.getType().getDisplayId()})));
        }
    }

    private RefMatcherType validateMatcherType(String type, List<RestErrorMessage> errors) {
        RefMatcherProvider provider = this.refMatcherProviderRegistry.getProvider(type);
        if (provider == null || type.length() > 255) {
            errors.add(new RestErrorMessage(MATCHER_TYPE_ID, this.i18nService.getMessage(INVALID_MATCHER_TYPE, new Object[]{type})));
            return null;
        }
        return provider.getType();
    }

    private SetRestrictionRequest validateRestrictionRequest(Scope scope, RestRestrictionRequest restriction, List<RestErrorMessage> errors) {
        RefMatcher matcher = this.validateMatcher(scope, restriction.getMatcher(), errors);
        Set<String> groups = this.validateGroups(restriction.getGroupNames(), errors);
        Set<ApplicationUser> users = this.validateUsers(restriction.getUserSlugs(), errors);
        Set<SshAccessKey> accessKeys = this.validateAccessKeys(restriction.getAccessKeyIds(), scope, errors);
        RefRestrictionType type = this.validateType(restriction.getType(), errors);
        this.validateMatcherAndTypeCombination(matcher, type, errors);
        if (!errors.isEmpty()) {
            return null;
        }
        return new SetRestrictionRequest.Builder(scope, matcher, type).grantGroups(groups).grantUsers(users).grantAccessKeys(accessKeys).build();
    }

    private RefRestrictionType validateType(String type, List<RestErrorMessage> errors) {
        try {
            return RefRestrictionType.forId(type);
        }
        catch (IllegalArgumentException e) {
            errors.add(new RestErrorMessage("type", this.i18nService.getMessage(INVALID_RESTRICTION_TYPE, new Object[]{type})));
            return null;
        }
    }

    private Set<RefRestrictionType> validateTypes(Collection<String> types, List<RestErrorMessage> errors) {
        HashSet<RefRestrictionType> result = new HashSet<RefRestrictionType>();
        for (String typeString : types) {
            RefRestrictionType type = this.validateType(typeString, errors);
            if (type == null) continue;
            result.add(type);
        }
        return result;
    }

    private Set<ApplicationUser> validateUsers(Collection<String> requestedUsers, List<RestErrorMessage> errors) {
        LinkedHashSet<String> usernames = new LinkedHashSet<String>(requestedUsers);
        Set users = this.userService.getUsersByName(usernames);
        if (users.size() != usernames.size()) {
            Set foundUsernames = users.stream().map(Principal::getName).collect(Collectors.toSet());
            usernames.stream().filter(username -> !foundUsernames.contains(username)).forEach(username -> errors.add(new RestErrorMessage("users", this.i18nService.getMessage(INVALID_USER, new Object[]{username}))));
        }
        users.stream().filter(this.isLicensed.negate()).forEach(unlicensedUser -> errors.add(new RestErrorMessage("users", this.i18nService.getMessage(USER_UNLICENSED, new Object[]{unlicensedUser.getDisplayName()}))));
        return users;
    }
}

