/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.rest;

import com.atlassian.bitbucket.repository.ref.restriction.AccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.AccessKeyAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.GroupAccessGrant;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RestRefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.UserAccessGrant;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import com.atlassian.bitbucket.rest.v2.api.user.RestApplicationUser;
import com.atlassian.stash.internal.repository.ref.restriction.rest.RestSshAccessKey;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public class RestRefRestriction
extends RestMapEntity {
    protected static final String ACCESS_KEYS = "accessKeys";
    protected static final String GROUPS = "groups";
    protected static final String MATCHER = "matcher";
    protected static final String SCOPE = "scope";
    protected static final String TYPE = "type";
    protected static final String USERS = "users";
    private static final String ID = "id";

    public RestRefRestriction() {
    }

    public RestRefRestriction(RefRestriction restriction) {
        this(restriction.getId(), new RestScope(restriction.getScope()), restriction.getType().getId(), new RestRefMatcher(restriction.getMatcher()), restriction.getAccessGrants());
    }

    protected RestRefRestriction(int id, RestScope scope, String type, RestRefMatcher matcher, List<AccessGrant> accessGrants) {
        this.put(ID, id);
        this.put(SCOPE, scope);
        this.put(TYPE, type);
        this.put(MATCHER, (Object)matcher);
        this.put(USERS, accessGrants.stream().filter(grant -> grant instanceof UserAccessGrant).map(UserAccessGrant.class::cast).map(UserAccessGrant::getUser).map(RestApplicationUser::new).collect(Collectors.toList()));
        this.put(GROUPS, accessGrants.stream().filter(grant -> grant instanceof GroupAccessGrant).map(GroupAccessGrant.class::cast).map(GroupAccessGrant::getGroup).collect(Collectors.toList()));
        this.put(ACCESS_KEYS, accessGrants.stream().filter(grant -> grant instanceof AccessKeyAccessGrant).map(AccessKeyAccessGrant.class::cast).map(AccessKeyAccessGrant::getAccessKey).map(RestSshAccessKey::new).collect(Collectors.toList()));
    }

    @Schema(example="1", accessMode=Schema.AccessMode.READ_ONLY)
    public int getId() {
        return this.getIntProperty(ID);
    }

    public RestRefMatcher getMatcher() {
        return RestRefMatcher.valueOf(this.get(MATCHER));
    }

    @Schema(accessMode=Schema.AccessMode.READ_ONLY)
    public RestScope getScope() {
        return RestScope.valueOf((Object)this.get(SCOPE));
    }

    @Schema(example="pull-request-only")
    public String getType() {
        return this.getStringProperty(TYPE);
    }

    public Collection<RestApplicationUser> getUsers() {
        return (Collection)this.get(USERS);
    }

    @Schema(example="[\"group_a\", \"group_b\"]")
    public Collection<String> getGroups() {
        return (Collection)this.get(GROUPS);
    }

    public Collection<RestSshAccessKey> getAccessKeys() {
        return (Collection)this.get(ACCESS_KEYS);
    }
}

