/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.rest;

import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.stash.internal.repository.ref.restriction.rest.RestRefRestriction;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class RestRestrictionRequest
extends RestRefRestriction {
    public RestRestrictionRequest() {
    }

    RestRestrictionRequest(RefRestriction restriction, List<String> groups, List<String> users, List<String> accessKeys) {
        super(restriction);
        this.putIfNotNull("users", users);
        this.putIfNotNull("groups", groups);
        this.putIfNotNull("accessKeys", accessKeys);
    }

    @Schema(example="[\"bman\", \"tstark\", \"hulk\"]")
    @Nonnull
    public Collection<String> getUserSlugs() {
        return this.getStringCollection("users");
    }

    @Schema(example="[\"bitbucket-developers\"]")
    @Nonnull
    public Collection<String> getGroupNames() {
        return this.getStringCollection("groups");
    }

    @Schema(example="[1, 2, 3]")
    @Nonnull
    public Collection<Integer> getAccessKeyIds() {
        return this.getIntegerCollection("accessKeys");
    }

    @Nonnull
    private Collection<String> getStringCollection(String key) {
        return this.getCollection(key).stream().map(Object::toString).collect(Collectors.toList());
    }

    @Nonnull
    private Collection<Integer> getIntegerCollection(String key) {
        return this.getCollection(key).stream().map(Object::toString).map(Integer::valueOf).collect(Collectors.toList());
    }

    @Nonnull
    private Collection<?> getCollection(String key) {
        Object rawCollection = this.get(key);
        Collection<Object> collection = rawCollection == null || !(rawCollection instanceof Collection) ? Collections.emptyList() : (Collection)rawCollection;
        return collection;
    }
}

