/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshKey;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nullable;
import java.util.Map;

@JsonSerialize
public class RestSshAccessKey
extends RestMapEntity {
    private static final String KEY = "key";

    public RestSshAccessKey() {
    }

    public RestSshAccessKey(SshAccessKey accessKey) {
        this.put(KEY, (Object)new RestSshKey(accessKey.getKey()));
    }

    public RestSshKey getKey() {
        return RestSshKey.valueOf(this.get(KEY));
    }

    private static class RestSshKey
    extends RestMapEntity {
        private static final String ID = "id";
        private static final String LABEL = "label";
        private static final String TEXT = "text";

        public RestSshKey(SshKey sshKey) {
            this(sshKey.getId(), sshKey.getText(), sshKey.getLabel());
        }

        public RestSshKey(Integer id, String text, String label) {
            this.putIfNotNull(ID, id);
            this.putIfNotNull(TEXT, text);
            this.putIfNotNull(LABEL, label);
        }

        private RestSshKey(Map<String, Object> map) {
            super(map);
        }

        @Schema(example="123")
        public Integer getId() {
            return this.getIntProperty(ID);
        }

        @Schema(example="me@127.0.0.1")
        public String getLabel() {
            return this.getStringProperty(LABEL);
        }

        @Schema(example="ssh-rsa AAAAB3... me@127.0.0.1")
        public String getText() {
            return this.getStringProperty(TEXT);
        }

        @Nullable
        public static RestSshKey valueOf(@Nullable Object value) {
            if (value instanceof RestSshKey) {
                return (RestSshKey)((Object)value);
            }
            if (value instanceof Map) {
                return new RestSshKey((Map)value);
            }
            return null;
        }
    }
}

