/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.repository.ref.restriction.web;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectSupplier;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.ref.restriction.RefRestriction;
import com.atlassian.bitbucket.repository.ref.restriction.RestrictionSearchRequest;
import com.atlassian.bitbucket.rest.v2.api.enrich.AvatarEnricher;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.usersettings.UserSettings;
import com.atlassian.sal.api.usersettings.UserSettingsService;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.stash.internal.repository.ref.restriction.DefaultRefRestrictionService;
import com.atlassian.stash.internal.repository.ref.restriction.rest.RestRefRestriction;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

@LicensedOnly
public class RefRestrictionsServlet
extends HttpServlet {
    private static final String SHOW_FIRST_CONTACT_PAGE_KEY = "SHOW_FIRST_CONTACT_PAGE";
    private static final String PROP_FEATURE_SPLASH = "plugin.ref-restriction.feature.splash";
    private final ApplicationPropertiesService propertiesService;
    private final AvatarEnricher avatarEnricher;
    private final DefaultRefRestrictionService restrictionsService;
    private final NavBuilder navBuilder;
    private final RefService refService;
    private final RepositorySupplier repositorySupplier;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final AuthenticationContext authenticationContext;
    private final UserSettingsService userSettingsService;
    private final PermissionValidationService validationService;
    private final PermissionService permissionService;
    private final ProjectSupplier projectSupplier;

    public RefRestrictionsServlet(ApplicationPropertiesService propertiesService, AvatarEnricher avatarEnricher, RefService refService, RepositorySupplier repositorySupplier, DefaultRefRestrictionService restrictionsService, NavBuilder navBuilder, SoyTemplateRenderer soyTemplateRenderer, AuthenticationContext authenticationContext, UserSettingsService userSettingsService, PermissionValidationService validationService, PermissionService permissionService, ProjectSupplier projectSupplier) {
        this.propertiesService = propertiesService;
        this.avatarEnricher = avatarEnricher;
        this.refService = refService;
        this.repositorySupplier = repositorySupplier;
        this.restrictionsService = restrictionsService;
        this.navBuilder = navBuilder;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.authenticationContext = authenticationContext;
        this.userSettingsService = userSettingsService;
        this.validationService = validationService;
        this.permissionService = permissionService;
        this.projectSupplier = projectSupplier;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String pathInfo = req.getPathInfo();
        Optional<Scope> opScope = this.getScope(pathInfo);
        if (!opScope.isPresent()) {
            resp.sendError(404);
            return;
        }
        Scope scope = opScope.get();
        this.doView(scope, req, resp);
    }

    private Optional<Scope> getScope(String pathInfo) {
        if (Strings.isNullOrEmpty((String)pathInfo)) {
            return Optional.empty();
        }
        String[] parts = pathInfo.substring(1).split("/");
        switch (parts.length) {
            case 2: {
                return Optional.ofNullable(this.repositorySupplier.getBySlug(parts[0], parts[1])).map(Scopes::repository);
            }
            case 1: {
                return Optional.ofNullable(this.projectSupplier.getByKey(parts[0])).map(Scopes::project);
            }
        }
        return Optional.empty();
    }

    private void addAvatars(boolean isSecure, List<RestRefRestriction> restrictions) {
        restrictions.forEach(restriction -> this.avatarEnricher.enrich(restriction.getUsers(), new AvatarRequest(isSecure, 32)));
    }

    private void doView(Scope scope, final HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        UserKey currentUserKey;
        UserSettings userSettings;
        Page<RefRestriction> restrictions;
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                RefRestrictionsServlet.this.validationService.validateForProject(scope.getProject(), Permission.PROJECT_ADMIN);
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                RefRestrictionsServlet.this.validationService.validateForRepository(scope.getRepository(), Permission.REPO_ADMIN);
                return null;
            }
        });
        try {
            restrictions = this.restrictionsService.search(new RestrictionSearchRequest.Builder(scope).build(), PageUtils.newRequest((int)0, (int)500));
        }
        catch (ArgumentValidationException e) {
            resp.sendError(400, e.getLocalizedMessage());
            return;
        }
        ApplicationUser currentUser = this.authenticationContext.getCurrentUser();
        boolean isFirstContact = false;
        if (currentUser != null && this.showSplashScreen(userSettings = this.userSettingsService.getUserSettings(currentUserKey = UserKey.fromLong((long)currentUser.getId())))) {
            isFirstContact = true;
            this.userSettingsService.updateUserSettings(currentUserKey, input -> {
                input.put(SHOW_FIRST_CONTACT_PAGE_KEY, false);
                return input.build();
            });
        }
        final ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"isFirstContact", (Object)isFirstContact).put((Object)"refRestrictions", this.restify(req.isSecure(), restrictions));
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                builder.put((Object)"project", (Object)scope.getProject());
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                Project project = scope.getProject();
                builder.put((Object)"project", (Object)project);
                builder.put((Object)"repository", (Object)scope.getRepository());
                if (RefRestrictionsServlet.this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
                    builder.put((Object)"projectSettingsUrl", (Object)RefRestrictionsServlet.this.navBuilder.pluginServlets().path(new String[]{"branch-permissions", project.getKey()}).buildRelative());
                }
                RefRestrictionsServlet.this.setBranchIfAvailable(req, (ImmutableMap.Builder<String, Object>)builder, scope);
                return null;
            }
        });
        builder.put((Object)"scopeType", (Object)scope.getType());
        this.render(resp, "bitbucketPluginRefRestriction.internal.page.serverSideBranchPermissions.viewBranchPermissions", (Map<String, Object>)builder.build());
    }

    private void setBranchIfAvailable(HttpServletRequest req, ImmutableMap.Builder<String, Object> builder, RepositoryScope rScope) {
        Ref ref;
        String at = req.getParameter("at");
        Branch branch = null;
        if (at != null && (ref = this.refService.resolveRef(new ResolveRefRequest.Builder(rScope.getRepository()).refId(at).type((RefType)StandardRefType.BRANCH).build())) instanceof Branch) {
            branch = (Branch)ref;
        }
        if (branch != null) {
            builder.put((Object)"branch", branch);
        }
    }

    private void render(HttpServletResponse resp, String templateName, Map<String, Object> data) throws IOException, ServletException {
        resp.setContentType("text/html;charset=UTF-8");
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), "com.atlassian.bitbucket.server.bitbucket-ref-restriction:branch-permissions-serverside", templateName, data);
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }

    private Iterable<RestRefRestriction> restify(boolean isSecure, Page<RefRestriction> restrictionPage) {
        ArrayList<RestRefRestriction> restrictions = new ArrayList<RestRefRestriction>();
        for (RefRestriction restriction : restrictionPage.getValues()) {
            restrictions.add(new RestRefRestriction(restriction));
        }
        this.addAvatars(isSecure, restrictions);
        return restrictions;
    }

    private boolean showSplashScreen(UserSettings userSettings) {
        return this.propertiesService.getPluginProperty(PROP_FEATURE_SPLASH, true) && userSettings.getBoolean(SHOW_FIRST_CONTACT_PAGE_KEY).isEmpty();
    }
}

