/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.common.rest.model;

import com.atlassian.plugins.authentication.common.rest.model.RestPageRequest;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;

@JsonAutoDetect(getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE)
public class RestPage<T> {
    public static final String LAST_PAGE_PROPERTY = "isLastPage";
    public static final String LIMIT_PROPERTY = "limit";
    public static final String START_PROPERTY = "start";
    public static final String SIZE_PROPERTY = "size";
    public static final String VALUES_PROPERTY = "results";
    @JsonProperty(value="results")
    private List<T> results;
    @JsonProperty(value="size")
    private int size;
    @JsonProperty(value="start")
    private int start;
    @JsonProperty(value="limit")
    private int limit;
    @JsonProperty(value="isLastPage")
    private boolean isLastPage;

    protected RestPage() {
    }

    public RestPage(List<T> results, int size, int start, int limit, boolean isLastPage) {
        this.results = results;
        this.size = size;
        this.start = start;
        this.limit = limit;
        this.isLastPage = isLastPage;
    }

    public List<T> getResults() {
        return this.results;
    }

    public int getSize() {
        return this.size;
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public boolean isLastPage() {
        return this.isLastPage;
    }

    public static <T> RestPage<T> fromListPlusOne(List<T> results, RestPageRequest pageRequest) {
        int limit = pageRequest.getLimit();
        int start = pageRequest.getStart();
        if (pageRequest.isAllResultsQuery()) {
            return new RestPage<T>(results, results.size(), start, limit, true);
        }
        List<T> trimmedResults = results.size() > limit ? results.subList(0, limit) : results;
        return new RestPage<T>(trimmedResults, trimmedResults.size(), start, limit, results.size() <= limit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestPage restPage = (RestPage)o;
        return this.size == restPage.size && this.start == restPage.start && this.limit == restPage.limit && this.isLastPage == restPage.isLastPage && Objects.equals(this.results, restPage.results);
    }

    public int hashCode() {
        return Objects.hash(this.results, this.size, this.start, this.limit, this.isLastPage);
    }

    public String toString() {
        return "RestPage{results=" + String.valueOf(this.results) + ", size=" + this.size + ", start=" + this.start + ", limit=" + this.limit + ", isLastPage=" + this.isLastPage + "}";
    }
}

