/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.StringJoiner;

public class AuthenticationEntity {
    @JsonProperty(value="username")
    private final String username;
    @JsonProperty(value="password")
    private final String password;
    @JsonProperty(value="targetUrl")
    private final String targetUrl;
    @JsonProperty(value="rememberMe", defaultValue="false")
    private final boolean rememberMe;
    @JsonProperty(value="captchaId", defaultValue="")
    private final String captchaId;
    @JsonProperty(value="captchaChallenge", defaultValue="")
    private final String captchaChallenge;

    @JsonCreator
    public AuthenticationEntity(@JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="targetUrl") String targetUrl, @JsonProperty(value="rememberMe") boolean rememberMe, @JsonProperty(value="captchaId") String captchaId, @JsonProperty(value="captchaChallenge") String captchaChallenge) {
        this.username = username;
        this.password = password;
        this.targetUrl = targetUrl;
        this.rememberMe = rememberMe;
        this.captchaId = captchaId;
        this.captchaChallenge = captchaChallenge;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getTargetUrl() {
        return this.targetUrl;
    }

    public boolean getRememberMe() {
        return this.rememberMe;
    }

    public String getCaptchaId() {
        return this.captchaId;
    }

    public String getCaptchaChallenge() {
        return this.captchaChallenge;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationEntity that = (AuthenticationEntity)o;
        return Objects.equals(this.getUsername(), that.getUsername()) && Objects.equals(this.getPassword(), that.getPassword()) && Objects.equals(this.getTargetUrl(), that.getTargetUrl()) && Objects.equals(this.getRememberMe(), that.getRememberMe()) && Objects.equals(this.getCaptchaId(), that.getCaptchaId()) && Objects.equals(this.getCaptchaChallenge(), that.getCaptchaChallenge());
    }

    public int hashCode() {
        return Objects.hash(this.getUsername(), this.getPassword(), this.getTargetUrl(), this.getRememberMe(), this.getCaptchaId(), this.getCaptchaChallenge());
    }

    public String toString() {
        return new StringJoiner(", ", this.getClass().getSimpleName() + "{", "}").add("username=" + this.getUsername()).add("password=" + this.getPassword()).add("targetUrl=" + this.getTargetUrl()).add("rememberMe=" + this.getRememberMe()).add("captchaId=" + this.getCaptchaId()).add("captchaChallenge=" + this.getCaptchaChallenge()).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AuthenticationEntity data) {
        return new Builder(data);
    }

    public static final class Builder {
        private String username;
        private String password;
        private String targetUrl;
        private boolean rememberMe;
        private String captchaId;
        private String captchaChallenge;

        private Builder() {
        }

        private Builder(AuthenticationEntity initialData) {
            this.username = initialData.username;
            this.password = initialData.password;
            this.targetUrl = initialData.targetUrl;
            this.rememberMe = initialData.rememberMe;
            this.captchaId = initialData.captchaId;
            this.captchaChallenge = initialData.captchaChallenge;
        }

        public Builder setUsername(String username) {
            this.username = username;
            return this;
        }

        public Builder setPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder setTargetUrl(String targetUrl) {
            this.targetUrl = targetUrl;
            return this;
        }

        public Builder setRememberMe(boolean rememberMe) {
            this.rememberMe = rememberMe;
            return this;
        }

        public Builder setCaptchaId(String captchaId) {
            this.captchaId = captchaId;
            return this;
        }

        public Builder setCaptchaChallenge(String captchaChallenge) {
            this.captchaChallenge = captchaChallenge;
            return this;
        }

        public AuthenticationEntity build() {
            return new AuthenticationEntity(this.username, this.password, this.targetUrl, this.rememberMe, this.captchaId, this.captchaChallenge);
        }
    }
}

