/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.model;

import com.atlassian.plugins.authentication.common.rest.model.ISO8601DateDeserializer;
import com.atlassian.plugins.authentication.common.rest.model.ISO8601DateSerializer;
import com.atlassian.plugins.authentication.tsv.model.Method;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.ZonedDateTime;
import java.util.Objects;

public class MethodStateDTO {
    @JsonProperty(value="type")
    private final Method type;
    @JsonProperty(value="enabled")
    private final boolean enabled;
    @JsonProperty(value="enabledAt")
    @JsonDeserialize(using=ISO8601DateDeserializer.class)
    @JsonSerialize(using=ISO8601DateSerializer.class)
    private final ZonedDateTime enabledAt;
    @JsonProperty(value="enforced")
    private final boolean enforced;

    @JsonCreator
    public MethodStateDTO(@JsonProperty(value="type") @Nonnull Method type, @JsonProperty(value="enabled") boolean enabled, @JsonProperty(value="enabledAt") @Nullable ZonedDateTime enabledAt, @JsonProperty(value="enforced") boolean enforced) {
        this.type = type;
        this.enabled = enabled;
        this.enabledAt = enabledAt;
        this.enforced = enforced;
    }

    @Nonnull
    public Method getType() {
        return this.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @Nullable
    public ZonedDateTime getEnabledAt() {
        return this.enabledAt;
    }

    public boolean isEnforced() {
        return this.enforced;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodStateDTO that = (MethodStateDTO)o;
        return this.enabled == that.enabled && this.enforced == that.enforced && this.type == that.type && Objects.equals(this.enabledAt, that.enabledAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.enabled, this.enabledAt, this.enforced});
    }

    public String toString() {
        return "TsvMethodState{type=" + String.valueOf((Object)this.type) + ", enabled=" + this.enabled + ", enabledAt=" + String.valueOf(this.enabledAt) + ", enforced=" + this.enforced + "}";
    }
}

