/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.model;

import com.atlassian.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicReference;

public class UserRateLimit {
    private static final int BACKOFF_MULTIPLIER = 2;
    private final String userKey;
    private final AtomicReference<FailureDescriptor> consecutiveFailures = new AtomicReference<FailureDescriptor>(new FailureDescriptor());

    public UserRateLimit(@Nonnull String userKey) {
        Objects.requireNonNull(userKey, "Invalid user key, cannot be null");
        this.userKey = userKey;
    }

    public UserRateLimit(@Nonnull String userKey, int consecutiveFailures, int nextBackoffInSeconds, long nextAllowedTime) {
        Objects.requireNonNull(userKey, "Invalid user key, cannot be null");
        this.userKey = userKey;
        this.consecutiveFailures.set(new FailureDescriptor(consecutiveFailures, nextBackoffInSeconds, nextAllowedTime));
    }

    public String getUserKey() {
        return this.userKey;
    }

    public int getConsecutiveFailures() {
        return this.consecutiveFailures.get().getConsecutiveFailures();
    }

    public int getNextBackoffInSeconds() {
        return this.consecutiveFailures.get().getNextBackoffInSeconds();
    }

    public long getNextAllowedTime() {
        return this.consecutiveFailures.get().getNextAllowedTime();
    }

    public void incrementConsecutiveFailures() {
        FailureDescriptor newLimit;
        FailureDescriptor currentFailure = this.consecutiveFailures.get();
        while (this.consecutiveFailures.compareAndSet(currentFailure, newLimit = this.consecutiveFailures.get().incrementConsecutiveFailures())) {
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserRateLimit)) {
            return false;
        }
        UserRateLimit that = (UserRateLimit)o;
        return Objects.equals(this.getUserKey(), that.getUserKey()) && Objects.equals(this.getConsecutiveFailures(), that.getConsecutiveFailures()) && Objects.equals(this.getNextBackoffInSeconds(), that.getNextBackoffInSeconds()) && Objects.equals(this.getNextAllowedTime(), that.getNextAllowedTime());
    }

    public int hashCode() {
        return Objects.hash(this.getUserKey(), this.getConsecutiveFailures(), this.getNextBackoffInSeconds(), this.getNextAllowedTime());
    }

    public String toString() {
        return new StringJoiner(", ", UserRateLimit.class.getSimpleName() + "[", "]").add("userKey='" + this.getUserKey() + "'").add("consecutiveFailures=" + this.getConsecutiveFailures()).add("nextBackoffInSeconds=" + this.getNextBackoffInSeconds()).add("nextAllowedTime=" + Instant.ofEpochSecond(this.getNextAllowedTime()).toString()).add("nextAllowedTimeInEpochSeconds=" + this.getNextAllowedTime()).toString();
    }

    public static class FailureDescriptor {
        public static final String MAX_BACKOFF_PERIOD_IN_MINUTES_PROPERTY = "atlassian.authentication.2sv.rate.limit.max.backoff.period.minutes";
        public static final String MAX_TOLERATED_FAILURES_COUNT = "atlassian.authentication.2sv.rate.limit.tolerated.failures.count";
        private static final int MAX_BACKOFF_PERIOD_IN_MINUTES = Integer.getInteger("atlassian.authentication.2sv.rate.limit.max.backoff.period.minutes", (int)Duration.ofMinutes(60L).toMinutes());
        private final int consecutiveFailures;
        private final int nextBackoffInSeconds;
        private final long nextAllowedTime;

        public FailureDescriptor() {
            this(FailureDescriptor.getToleratedMistakesCount(), FailureDescriptor.backoffTime(FailureDescriptor.getToleratedMistakesCount()), FailureDescriptor.nextAllowedTime(FailureDescriptor.getToleratedMistakesCount()));
        }

        public FailureDescriptor(int consecutiveFailures) {
            this(consecutiveFailures, FailureDescriptor.backoffTime(consecutiveFailures), FailureDescriptor.nextAllowedTime(consecutiveFailures));
        }

        @VisibleForTesting
        public FailureDescriptor(int consecutiveFailures, int nextBackoffInSeconds, long nextAllowedTime) {
            this.consecutiveFailures = consecutiveFailures;
            this.nextBackoffInSeconds = nextBackoffInSeconds;
            this.nextAllowedTime = nextAllowedTime;
        }

        static int consecutiveFailures(int consecutiveFailures) {
            return Math.max(consecutiveFailures, 0);
        }

        static int backoffTime(int consecutiveFailures) {
            if (consecutiveFailures <= 0) {
                return 0;
            }
            return Math.min((int)Math.pow(2.0, FailureDescriptor.consecutiveFailures(consecutiveFailures - 1)), MAX_BACKOFF_PERIOD_IN_MINUTES * 60);
        }

        @VisibleForTesting
        static int getToleratedMistakesCount() {
            int sysPropValue = Integer.getInteger(MAX_TOLERATED_FAILURES_COUNT, -1);
            if (sysPropValue > 0) {
                sysPropValue = -sysPropValue;
            }
            return Math.min(-1, sysPropValue);
        }

        static long nextAllowedTime(int consecutiveFailures) {
            return Instant.now().getEpochSecond() + (long)FailureDescriptor.backoffTime(consecutiveFailures);
        }

        public FailureDescriptor incrementConsecutiveFailures() {
            return new FailureDescriptor(this.consecutiveFailures + 1);
        }

        public int getConsecutiveFailures() {
            return FailureDescriptor.consecutiveFailures(this.consecutiveFailures);
        }

        public int getNextBackoffInSeconds() {
            return Math.min(this.nextBackoffInSeconds, MAX_BACKOFF_PERIOD_IN_MINUTES * 60);
        }

        public long getNextAllowedTime() {
            return this.nextAllowedTime;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FailureDescriptor that = (FailureDescriptor)o;
            return this.consecutiveFailures == that.consecutiveFailures && this.nextBackoffInSeconds == that.nextBackoffInSeconds && this.nextAllowedTime == that.nextAllowedTime;
        }

        public int hashCode() {
            return Objects.hash(this.consecutiveFailures, this.nextBackoffInSeconds, this.nextAllowedTime);
        }

        public String toString() {
            return "FailureDescriptor{consecutiveFailures=" + this.consecutiveFailures + ", nextBackoffInSeconds=" + this.nextBackoffInSeconds + ", nextAllowedTime=" + this.nextAllowedTime + "}";
        }
    }
}

