/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.exception.mapper;

import com.atlassian.plugins.authentication.api.tsv.internal.exception.RateLimitedExceededException;
import com.atlassian.plugins.authentication.common.rest.model.ErrorEntity;
import com.atlassian.sal.api.message.I18nResolver;
import jakarta.inject.Inject;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import java.time.Instant;

@Provider
public class RateLimitedExceededExceptionMapper
implements ExceptionMapper<RateLimitedExceededException> {
    private final I18nResolver i18nResolver;
    public static final String RATE_LIMIT_EXCEEDED_ERROR = "authentication.two-step-verification.rate.limiting.exceeded";

    @Inject
    public RateLimitedExceededExceptionMapper(I18nResolver i18nResolver) {
        this.i18nResolver = i18nResolver;
    }

    public Response toResponse(RateLimitedExceededException e) {
        long retryAfter = Math.max(e.getRateLimitDTO().nextAllowedTime() - Instant.now().getEpochSecond(), 0L);
        return Response.status((int)429).header("Retry-After", (Object)retryAfter).entity((Object)new ErrorEntity(this.i18nResolver.getText(RATE_LIMIT_EXCEEDED_ERROR))).build();
    }
}

