/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.filter;

import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.LegacyModeEnabledException;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthenticationPluginFeatureService;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=4980)
public class LegacyModeFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(LegacyModeFilter.class);
    private final AuthenticationPluginFeatureService authenticationPluginFeatureService;
    @Context
    private ResourceInfo resourceInfo;

    @Inject
    public LegacyModeFilter(AuthenticationPluginFeatureService authenticationPluginFeatureService) {
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
    }

    public void filter(ContainerRequestContext requestContext) {
        if (this.isDisabledInLegacyMode() && this.authenticationPluginFeatureService.isLegacyModeEnabled()) {
            log.warn("Legacy mode is enabled, rejecting 2SV API request");
            throw new LegacyModeEnabledException();
        }
    }

    private boolean isDisabledInLegacyMode() {
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        return resourceMethod != null && this.hasDisabledInLegacyModeAnnotation(resourceMethod);
    }

    private boolean hasDisabledInLegacyModeAnnotation(Method resourceMethod) {
        return resourceMethod.isAnnotationPresent(DisabledInLegacyMode.class) || resourceMethod.getDeclaringClass().isAnnotationPresent(DisabledInLegacyMode.class);
    }
}

