/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.tsv.rest.filter;

import com.atlassian.plugins.authentication.api.tsv.internal.annotation.RequiresTsvWebSudoFeature;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.TsvWebsudoDisabledException;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthenticationPluginFeatureService;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.ext.Provider;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=4990)
public class TsvWebSudoFilter
implements ContainerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(TsvWebSudoFilter.class);
    private final AuthenticationPluginFeatureService authenticationPluginFeatureService;
    @Context
    private ResourceInfo resourceInfo;

    @Inject
    public TsvWebSudoFilter(AuthenticationPluginFeatureService authenticationPluginFeatureService) {
        this.authenticationPluginFeatureService = authenticationPluginFeatureService;
    }

    public void filter(ContainerRequestContext requestContext) {
        if (this.isDisabledWhenTsvWebSudoFeatureDisabled() && this.authenticationPluginFeatureService.isTsvWebsudoDisabled()) {
            log.warn("2SV web sudo feature is disabled, rejecting 2SV web sudo API request");
            throw new TsvWebsudoDisabledException();
        }
    }

    private boolean isDisabledWhenTsvWebSudoFeatureDisabled() {
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        return resourceMethod != null && this.hasRequiresTsvWebSudoFeatureAnnotation(resourceMethod);
    }

    private boolean hasRequiresTsvWebSudoFeatureAnnotation(Method resourceMethod) {
        return resourceMethod.isAnnotationPresent(RequiresTsvWebSudoFeature.class) || resourceMethod.getDeclaringClass().isAnnotationPresent(RequiresTsvWebSudoFeature.class);
    }
}

