/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.authentication.websudo.rest;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.tsv.internal.events.TsvWebsudoVerificationEvent;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.EnrollmentNotFoundException;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.InvalidRecoveryCodeException;
import com.atlassian.plugins.authentication.api.tsv.internal.exception.InvalidTotpCodeException;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.RecoveryCodeService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.TotpService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.VerificationMethod;
import com.atlassian.plugins.authentication.api.tsv.websudo.internal.TsvEnrollmentStatus;
import com.atlassian.plugins.authentication.api.tsv.websudo.internal.service.TsvWebSudoService;
import com.atlassian.plugins.authentication.common.rest.model.ErrorEntity;
import com.atlassian.plugins.authentication.tsv.model.TotpElevationRestDTO;
import com.atlassian.plugins.authentication.tsv.model.TotpRecoveryCodeDTO;
import com.atlassian.plugins.authentication.websudo.rest.WebsudoResourceContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import io.atlassian.fugue.Either;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.core.Response;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class WebsudoController {
    private final TsvWebSudoService tsvWebSudoService;
    private final TotpService totpService;
    private final Predicate<HttpServletRequest> cannotExecuteWebsudoChecker;
    private final Consumer<HttpServletRequest> websudoSessionCreator;
    private final I18nResolver i18nResolver;
    private final RecoveryCodeService recoveryCodeService;
    private final UserManager userManager;
    private final AuthAuditService authAuditService;
    private final EventPublisher eventPublisher;

    public WebsudoController(TsvWebSudoService tsvWebSudoService, TotpService totpService, Predicate<HttpServletRequest> cannotExecuteWebsudoChecker, Consumer<HttpServletRequest> websudoSessionCreator, I18nResolver i18nResolver, RecoveryCodeService recoveryCodeService, UserManager userManager, AuthAuditService authAuditService, EventPublisher eventPublisher) {
        this.tsvWebSudoService = tsvWebSudoService;
        this.totpService = totpService;
        this.cannotExecuteWebsudoChecker = cannotExecuteWebsudoChecker;
        this.websudoSessionCreator = websudoSessionCreator;
        this.i18nResolver = i18nResolver;
        this.authAuditService = authAuditService;
        this.recoveryCodeService = recoveryCodeService;
        this.userManager = userManager;
        this.eventPublisher = eventPublisher;
    }

    public Response websudoWithTotp(WebsudoResourceContext<TotpElevationRestDTO> context) {
        return this.performWebsudo(context, (c, up) -> {
            if (this.totpService.isTotpCodeValid(up.getUserKey().getStringValue(), ((TotpElevationRestDTO)c.data()).getTotpCode())) {
                this.websudoSessionCreator.accept(context.request());
                this.authAuditService.logTsvWebSudoVerificationSuccess(up.getUserKey(), VerificationMethod.TOTP);
                this.eventPublisher.publish((Object)new TsvWebsudoVerificationEvent(up.getUserKey(), VerificationMethod.TOTP));
                return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
            }
            this.authAuditService.logTsvWebSudoVerificationFailure(up.getUserKey(), VerificationMethod.TOTP);
            throw new InvalidTotpCodeException();
        });
    }

    public Response websudoWithRecoveryCode(WebsudoResourceContext<TotpRecoveryCodeDTO> context) {
        return this.performWebsudo(context, (c, up) -> {
            Either responseOrError = this.recoveryCodeService.useRecoveryCode(up, ((TotpRecoveryCodeDTO)c.data()).getRecoveryCode()).map(recoveryCode -> {
                this.websudoSessionCreator.accept(context.request());
                this.authAuditService.logTsvWebSudoVerificationSuccess(up.getUserKey(), VerificationMethod.RECOVERY_KEY);
                this.eventPublisher.publish((Object)new TsvWebsudoVerificationEvent(up.getUserKey(), VerificationMethod.RECOVERY_KEY));
                return Response.ok().entity((Object)new TotpRecoveryCodeDTO((String)recoveryCode)).build();
            }).leftMap(recoveryCodeConsumptionError -> switch (recoveryCodeConsumptionError) {
                default -> throw new MatchException(null, null);
                case RecoveryCodeService.RecoveryCodeConsumptionError.USER_NOT_ENROLLED -> new EnrollmentNotFoundException();
                case RecoveryCodeService.RecoveryCodeConsumptionError.RECOVERY_CODE_INVALID -> {
                    this.authAuditService.logTsvWebSudoVerificationFailure(up.getUserKey(), VerificationMethod.RECOVERY_KEY);
                    yield new InvalidRecoveryCodeException();
                }
            });
            return (Response)responseOrError.getOrThrow(() -> (RuntimeException)responseOrError.left().get());
        });
    }

    private <T> Response performWebsudo(WebsudoResourceContext<T> context, BiFunction<WebsudoResourceContext<T>, UserProfile, Response> verificationMethodHandler) {
        if (this.cannotExecuteWebsudoChecker.test(context.request())) {
            return this.cannotExecuteWebsudoResponse();
        }
        UserProfile userProfile = this.userManager.getRemoteUser();
        if (userProfile == null) {
            throw new IllegalStateException(this.i18nResolver.getText("authentication.two-step-verification.unauthenticated.error.message"));
        }
        TsvEnrollmentStatus enrollmentStatus = this.tsvWebSudoService.getEnrollmentStatus();
        return switch (enrollmentStatus) {
            default -> throw new MatchException(null, null);
            case TsvEnrollmentStatus.NOT_ENROLLED -> throw new EnrollmentNotFoundException();
            case TsvEnrollmentStatus.ENROLLMENT_REQUIRED -> this.enforcedEnrollmentResponse();
            case TsvEnrollmentStatus.ENROLLED -> verificationMethodHandler.apply(context, userProfile);
        };
    }

    private Response enforcedEnrollmentResponse() {
        return Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.two-step-verification.websudo.enforcement-required"))).build();
    }

    private Response cannotExecuteWebsudoResponse() {
        return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new ErrorEntity(this.i18nResolver.getText("authentication.two-step-verification.websudo.cannot-execute"))).build();
    }
}

