/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.websudo.rest;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.auth.websudo.BitbucketWebSudoManager;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.DisabledInLegacyMode;
import com.atlassian.plugins.authentication.api.tsv.internal.annotation.RequiresTsvWebSudoFeature;
import com.atlassian.plugins.authentication.api.tsv.internal.service.AuthAuditService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.RecoveryCodeService;
import com.atlassian.plugins.authentication.api.tsv.internal.service.TotpService;
import com.atlassian.plugins.authentication.api.tsv.websudo.internal.service.TsvWebSudoService;
import com.atlassian.plugins.authentication.tsv.model.TotpElevationRestDTO;
import com.atlassian.plugins.authentication.tsv.model.TotpRecoveryCodeDTO;
import com.atlassian.plugins.authentication.websudo.rest.WebsudoController;
import com.atlassian.plugins.authentication.websudo.rest.WebsudoResourceContext;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.annotations.VisibleForTesting;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;

@Path(value="/elevate")
@AdminOnly
@DisabledInLegacyMode
@RequiresTsvWebSudoFeature
public class Bitbucket2SVWebsudoResource {
    private final WebsudoController websudoController;

    @Inject
    public Bitbucket2SVWebsudoResource(BitbucketWebSudoManager webSudoManager, TsvWebSudoService tsvWebSudoService, TotpService totpService, UserManager userManager, I18nResolver i18nResolver, RecoveryCodeService recoveryCodeService, AuthAuditService authAuditService, EventPublisher eventPublisher) {
        this(new WebsudoController(tsvWebSudoService, totpService, arg_0 -> ((BitbucketWebSudoManager)webSudoManager).cannotExecuteWebSudo(arg_0), arg_0 -> ((BitbucketWebSudoManager)webSudoManager).createWebSudoSession(arg_0), i18nResolver, recoveryCodeService, userManager, authAuditService, eventPublisher));
    }

    @VisibleForTesting
    Bitbucket2SVWebsudoResource(WebsudoController websudoController) {
        this.websudoController = websudoController;
    }

    @POST
    @Path(value="/recovery-code")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response websudoWithRecoveryCode(@Context HttpServletRequest req, TotpRecoveryCodeDTO recoveryCodeDTO) {
        return this.websudoController.websudoWithRecoveryCode(new WebsudoResourceContext<TotpRecoveryCodeDTO>(req, recoveryCodeDTO));
    }

    @POST
    @Path(value="/totp")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response websudoWithTotp(@Context HttpServletRequest req, TotpElevationRestDTO totpElevationRestDTO) {
        return this.websudoController.websudoWithTotp(new WebsudoResourceContext<TotpElevationRestDTO>(req, totpElevationRestDTO));
    }
}

