/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.transaction.annotation;

import java.lang.reflect.Method;
import org.springframework.context.ApplicationListener;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.event.TransactionPhase;
import org.springframework.transaction.event.TransactionalApplicationListenerMethodAdapter;
import org.springframework.transaction.event.TransactionalEventListenerFactory;

public class RestrictedTransactionalEventListenerFactory
extends TransactionalEventListenerFactory {
    @Override
    public ApplicationListener<?> createApplicationListener(String beanName, Class<?> type, Method method) {
        TransactionalApplicationListenerMethodAdapter adapter = new TransactionalApplicationListenerMethodAdapter(beanName, type, method);
        if (adapter.getTransactionPhase() != TransactionPhase.BEFORE_COMMIT) {
            Propagation propagation;
            Transactional txAnn = AnnotatedElementUtils.findMergedAnnotation(method, Transactional.class);
            if (txAnn == null) {
                txAnn = AnnotatedElementUtils.findMergedAnnotation(type, Transactional.class);
            }
            if (txAnn != null && (propagation = txAnn.propagation()) != Propagation.REQUIRES_NEW && propagation != Propagation.NOT_SUPPORTED) {
                throw new IllegalStateException("@TransactionalEventListener method must not be annotated with @Transactional unless when declared as REQUIRES_NEW or NOT_SUPPORTED: " + String.valueOf(method));
            }
        }
        return adapter;
    }
}

