/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.context.request.async;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.web.context.request.async.AsyncRequestNotUsableException;
import org.springframework.web.context.request.async.AsyncWebRequest;
import org.springframework.web.context.request.async.CallableInterceptorChain;
import org.springframework.web.context.request.async.CallableProcessingInterceptor;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.DeferredResultInterceptorChain;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.TimeoutCallableProcessingInterceptor;
import org.springframework.web.context.request.async.TimeoutDeferredResultProcessingInterceptor;
import org.springframework.web.context.request.async.WebAsyncTask;
import org.springframework.web.context.request.async.WebAsyncUtils;
import org.springframework.web.util.DisconnectedClientHelper;

public final class WebAsyncManager {
    private static final Object RESULT_NONE = new Object();
    private static final AsyncTaskExecutor DEFAULT_TASK_EXECUTOR = new SimpleAsyncTaskExecutor(WebAsyncManager.class.getSimpleName());
    private static final Log logger = LogFactory.getLog(WebAsyncManager.class);
    private static final CallableProcessingInterceptor timeoutCallableInterceptor = new TimeoutCallableProcessingInterceptor();
    private static final DeferredResultProcessingInterceptor timeoutDeferredResultInterceptor = new TimeoutDeferredResultProcessingInterceptor();
    @Nullable
    private AsyncWebRequest asyncWebRequest;
    private AsyncTaskExecutor taskExecutor = DEFAULT_TASK_EXECUTOR;
    private boolean isMultipartRequestParsed;
    @Nullable
    private volatile Object concurrentResult = RESULT_NONE;
    @Nullable
    private volatile Object[] concurrentResultContext;
    private final AtomicReference<State> state = new AtomicReference<State>(State.NOT_STARTED);
    private final Map<Object, CallableProcessingInterceptor> callableInterceptors = new LinkedHashMap<Object, CallableProcessingInterceptor>();
    private final Map<Object, DeferredResultProcessingInterceptor> deferredResultInterceptors = new LinkedHashMap<Object, DeferredResultProcessingInterceptor>();

    WebAsyncManager() {
    }

    public void setAsyncWebRequest(AsyncWebRequest asyncWebRequest) {
        Assert.notNull((Object)asyncWebRequest, "AsyncWebRequest must not be null");
        this.asyncWebRequest = asyncWebRequest;
        this.asyncWebRequest.addCompletionHandler(() -> asyncWebRequest.removeAttribute(WebAsyncUtils.WEB_ASYNC_MANAGER_ATTRIBUTE, 0));
    }

    @Nullable
    public AsyncWebRequest getAsyncWebRequest() {
        return this.asyncWebRequest;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public boolean isConcurrentHandlingStarted() {
        return this.asyncWebRequest != null && this.asyncWebRequest.isAsyncStarted();
    }

    public boolean hasConcurrentResult() {
        return this.concurrentResult != RESULT_NONE;
    }

    @Nullable
    public Object getConcurrentResult() {
        return this.concurrentResult;
    }

    @Nullable
    public Object[] getConcurrentResultContext() {
        return this.concurrentResultContext;
    }

    @Nullable
    public CallableProcessingInterceptor getCallableInterceptor(Object key) {
        return this.callableInterceptors.get(key);
    }

    @Nullable
    public DeferredResultProcessingInterceptor getDeferredResultInterceptor(Object key) {
        return this.deferredResultInterceptors.get(key);
    }

    public void registerCallableInterceptor(Object key, CallableProcessingInterceptor interceptor) {
        Assert.notNull(key, "Key is required");
        Assert.notNull((Object)interceptor, "CallableProcessingInterceptor is required");
        this.callableInterceptors.put(key, interceptor);
    }

    public void registerCallableInterceptors(CallableProcessingInterceptor ... interceptors) {
        Assert.notNull((Object)interceptors, "A CallableProcessingInterceptor is required");
        for (CallableProcessingInterceptor interceptor : interceptors) {
            String key = interceptor.getClass().getName() + ":" + interceptor.hashCode();
            this.callableInterceptors.put(key, interceptor);
        }
    }

    public void registerDeferredResultInterceptor(Object key, DeferredResultProcessingInterceptor interceptor) {
        Assert.notNull(key, "Key is required");
        Assert.notNull((Object)interceptor, "DeferredResultProcessingInterceptor is required");
        this.deferredResultInterceptors.put(key, interceptor);
    }

    public void registerDeferredResultInterceptors(DeferredResultProcessingInterceptor ... interceptors) {
        Assert.notNull((Object)interceptors, "A DeferredResultProcessingInterceptor is required");
        for (DeferredResultProcessingInterceptor interceptor : interceptors) {
            String key = interceptor.getClass().getName() + ":" + interceptor.hashCode();
            this.deferredResultInterceptors.put(key, interceptor);
        }
    }

    public void setMultipartRequestParsed(boolean isMultipart) {
        this.isMultipartRequestParsed = isMultipart;
    }

    public boolean isMultipartRequestParsed() {
        return this.isMultipartRequestParsed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConcurrentResult() {
        if (!this.state.compareAndSet(State.RESULT_SET, State.NOT_STARTED)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Unexpected call to clear: [" + String.valueOf((Object)this.state.get()) + "]"));
            }
            return;
        }
        WebAsyncManager webAsyncManager = this;
        synchronized (webAsyncManager) {
            this.concurrentResult = RESULT_NONE;
            this.concurrentResultContext = null;
        }
    }

    public void startCallableProcessing(Callable<?> callable, Object ... processingContext) throws Exception {
        Assert.notNull(callable, "Callable must not be null");
        this.startCallableProcessing(new WebAsyncTask(callable), processingContext);
    }

    public void startCallableProcessing(WebAsyncTask<?> webAsyncTask, Object ... processingContext) throws Exception {
        AsyncTaskExecutor executor;
        Assert.notNull(webAsyncTask, "WebAsyncTask must not be null");
        Assert.state(this.asyncWebRequest != null, "AsyncWebRequest must not be null");
        if (!this.state.compareAndSet(State.NOT_STARTED, State.ASYNC_PROCESSING)) {
            throw new IllegalStateException("Unexpected call to startCallableProcessing: [" + String.valueOf((Object)this.state.get()) + "]");
        }
        Long timeout = webAsyncTask.getTimeout();
        if (timeout != null) {
            this.asyncWebRequest.setTimeout(timeout);
        }
        if ((executor = webAsyncTask.getExecutor()) != null) {
            this.taskExecutor = executor;
        }
        ArrayList<CallableProcessingInterceptor> interceptors = new ArrayList<CallableProcessingInterceptor>();
        interceptors.add(webAsyncTask.getInterceptor());
        interceptors.addAll(this.callableInterceptors.values());
        interceptors.add(timeoutCallableInterceptor);
        Callable<?> callable = webAsyncTask.getCallable();
        CallableInterceptorChain interceptorChain = new CallableInterceptorChain(interceptors);
        this.asyncWebRequest.addTimeoutHandler(() -> {
            Object result;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Servlet container timeout notification for " + WebAsyncManager.formatUri(this.asyncWebRequest)));
            }
            if ((result = interceptorChain.triggerAfterTimeout(this.asyncWebRequest, callable)) != CallableProcessingInterceptor.RESULT_NONE) {
                this.setConcurrentResultAndDispatch(result);
            }
        });
        this.asyncWebRequest.addErrorHandler(ex -> {
            Object result;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Servlet container error notification for " + WebAsyncManager.formatUri(this.asyncWebRequest) + ": " + String.valueOf(ex)));
            }
            if (DisconnectedClientHelper.isClientDisconnectedException(ex)) {
                ex = new AsyncRequestNotUsableException("Servlet container error notification for disconnected client", (Throwable)ex);
            }
            result = (result = interceptorChain.triggerAfterError(this.asyncWebRequest, callable, (Throwable)ex)) != CallableProcessingInterceptor.RESULT_NONE ? result : ex;
            this.setConcurrentResultAndDispatch(result);
        });
        this.asyncWebRequest.addCompletionHandler(() -> interceptorChain.triggerAfterCompletion(this.asyncWebRequest, callable));
        interceptorChain.applyBeforeConcurrentHandling(this.asyncWebRequest, callable);
        this.startAsyncProcessing(processingContext);
        try {
            Future<?> future = this.taskExecutor.submit(() -> {
                Object result = null;
                try {
                    interceptorChain.applyPreProcess(this.asyncWebRequest, callable);
                    result = callable.call();
                }
                catch (Throwable ex) {
                    result = ex;
                }
                finally {
                    result = interceptorChain.applyPostProcess(this.asyncWebRequest, callable, result);
                }
                this.setConcurrentResultAndDispatch(result);
            });
            interceptorChain.setTaskFuture(future);
        }
        catch (Throwable ex2) {
            Object result = interceptorChain.applyPostProcess(this.asyncWebRequest, callable, ex2);
            this.setConcurrentResultAndDispatch(result);
        }
    }

    public void startDeferredResultProcessing(DeferredResult<?> deferredResult, Object ... processingContext) throws Exception {
        Assert.notNull(deferredResult, "DeferredResult must not be null");
        Assert.state(this.asyncWebRequest != null, "AsyncWebRequest must not be null");
        if (!this.state.compareAndSet(State.NOT_STARTED, State.ASYNC_PROCESSING)) {
            throw new IllegalStateException("Unexpected call to startDeferredResultProcessing: [" + String.valueOf((Object)this.state.get()) + "]");
        }
        Long timeout = deferredResult.getTimeoutValue();
        if (timeout != null) {
            this.asyncWebRequest.setTimeout(timeout);
        }
        ArrayList<DeferredResultProcessingInterceptor> interceptors = new ArrayList<DeferredResultProcessingInterceptor>();
        interceptors.add(deferredResult.getLifecycleInterceptor());
        interceptors.addAll(this.deferredResultInterceptors.values());
        interceptors.add(timeoutDeferredResultInterceptor);
        DeferredResultInterceptorChain interceptorChain = new DeferredResultInterceptorChain(interceptors);
        this.asyncWebRequest.addTimeoutHandler(() -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Servlet container timeout notification for " + WebAsyncManager.formatUri(this.asyncWebRequest)));
            }
            try {
                interceptorChain.triggerAfterTimeout(this.asyncWebRequest, deferredResult);
                WebAsyncManager webAsyncManager = this;
                synchronized (webAsyncManager) {
                    return;
                }
            }
            catch (Throwable ex) {
                this.setConcurrentResultAndDispatch(ex);
                return;
            }
        });
        this.asyncWebRequest.addErrorHandler(ex -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Servlet container error notification for " + WebAsyncManager.formatUri(this.asyncWebRequest)));
            }
            if (DisconnectedClientHelper.isClientDisconnectedException(ex)) {
                ex = new AsyncRequestNotUsableException("Servlet container error notification for disconnected client", (Throwable)ex);
            }
            try {
                interceptorChain.triggerAfterError(this.asyncWebRequest, deferredResult, (Throwable)ex);
                WebAsyncManager webAsyncManager = this;
                synchronized (webAsyncManager) {
                    return;
                }
            }
            catch (Throwable interceptorEx) {
                this.setConcurrentResultAndDispatch(interceptorEx);
                return;
            }
        });
        this.asyncWebRequest.addCompletionHandler(() -> interceptorChain.triggerAfterCompletion(this.asyncWebRequest, deferredResult));
        interceptorChain.applyBeforeConcurrentHandling(this.asyncWebRequest, deferredResult);
        this.startAsyncProcessing(processingContext);
        try {
            interceptorChain.applyPreProcess(this.asyncWebRequest, deferredResult);
            deferredResult.setResultHandler(result -> {
                result = interceptorChain.applyPostProcess(this.asyncWebRequest, deferredResult, result);
                this.setConcurrentResultAndDispatch(result);
            });
        }
        catch (Throwable ex2) {
            this.setConcurrentResultAndDispatch(ex2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAsyncProcessing(Object[] processingContext) {
        WebAsyncManager webAsyncManager = this;
        synchronized (webAsyncManager) {
            this.concurrentResult = RESULT_NONE;
            this.concurrentResultContext = processingContext;
        }
        Assert.state(this.asyncWebRequest != null, "AsyncWebRequest must not be null");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Started async request for " + WebAsyncManager.formatUri(this.asyncWebRequest)));
        }
        this.asyncWebRequest.startAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setConcurrentResultAndDispatch(@Nullable Object result) {
        Assert.state(this.asyncWebRequest != null, "AsyncWebRequest must not be null");
        WebAsyncManager webAsyncManager = this;
        synchronized (webAsyncManager) {
            if (!this.state.compareAndSet(State.ASYNC_PROCESSING, State.RESULT_SET)) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Async result already set: [" + String.valueOf((Object)this.state.get()) + "], ignored result for " + WebAsyncManager.formatUri(this.asyncWebRequest)));
                }
                return;
            }
            this.concurrentResult = result;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Async result set for " + WebAsyncManager.formatUri(this.asyncWebRequest)));
            }
            if (this.asyncWebRequest.isAsyncComplete()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Async request already completed for " + WebAsyncManager.formatUri(this.asyncWebRequest)));
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Performing async dispatch for " + WebAsyncManager.formatUri(this.asyncWebRequest)));
            }
            this.asyncWebRequest.dispatch();
        }
    }

    private static String formatUri(AsyncWebRequest asyncWebRequest) {
        HttpServletRequest request = asyncWebRequest.getNativeRequest(HttpServletRequest.class);
        return request != null ? "\"" + request.getRequestURI() + "\"" : "servlet container";
    }

    private static enum State {
        NOT_STARTED,
        ASYNC_PROCESSING,
        RESULT_SET;

    }
}

