/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.http.MediaType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.accept.ContentNegotiationManager;
import org.springframework.web.accept.ContentNegotiationManagerFactoryBean;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.context.support.WebApplicationObjectSupport;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.SmartView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;

public class ContentNegotiatingViewResolver
extends WebApplicationObjectSupport
implements ViewResolver,
Ordered,
InitializingBean {
    @Nullable
    private ContentNegotiationManager contentNegotiationManager;
    private final ContentNegotiationManagerFactoryBean cnmFactoryBean = new ContentNegotiationManagerFactoryBean();
    private boolean useNotAcceptableStatusCode = false;
    @Nullable
    private List<View> defaultViews;
    @Nullable
    private List<ViewResolver> viewResolvers;
    private int order = Integer.MIN_VALUE;
    private static final View NOT_ACCEPTABLE_VIEW = new View(){

        @Override
        @Nullable
        public String getContentType() {
            return null;
        }

        @Override
        public void render(@Nullable Map<String, ?> model, HttpServletRequest request, HttpServletResponse response) {
            response.setStatus(406);
        }
    };

    public void setContentNegotiationManager(@Nullable ContentNegotiationManager contentNegotiationManager) {
        this.contentNegotiationManager = contentNegotiationManager;
    }

    @Nullable
    public ContentNegotiationManager getContentNegotiationManager() {
        return this.contentNegotiationManager;
    }

    public void setUseNotAcceptableStatusCode(boolean useNotAcceptableStatusCode) {
        this.useNotAcceptableStatusCode = useNotAcceptableStatusCode;
    }

    public boolean isUseNotAcceptableStatusCode() {
        return this.useNotAcceptableStatusCode;
    }

    public void setDefaultViews(List<View> defaultViews) {
        this.defaultViews = defaultViews;
    }

    public List<View> getDefaultViews() {
        return this.defaultViews != null ? Collections.unmodifiableList(this.defaultViews) : Collections.emptyList();
    }

    public void setViewResolvers(List<ViewResolver> viewResolvers) {
        this.viewResolvers = viewResolvers;
    }

    public List<ViewResolver> getViewResolvers() {
        return this.viewResolvers != null ? Collections.unmodifiableList(this.viewResolvers) : Collections.emptyList();
    }

    public void setOrder(int order) {
        this.order = order;
    }

    @Override
    public int getOrder() {
        return this.order;
    }

    @Override
    protected void initServletContext(ServletContext servletContext) {
        Collection<ViewResolver> matchingBeans = BeanFactoryUtils.beansOfTypeIncludingAncestors(this.obtainApplicationContext(), ViewResolver.class).values();
        if (this.viewResolvers == null) {
            this.viewResolvers = new ArrayList<ViewResolver>(matchingBeans.size());
            for (ViewResolver viewResolver : matchingBeans) {
                if (this == viewResolver) continue;
                this.viewResolvers.add(viewResolver);
            }
        } else {
            for (int i2 = 0; i2 < this.viewResolvers.size(); ++i2) {
                ViewResolver vr = this.viewResolvers.get(i2);
                if (matchingBeans.contains(vr)) continue;
                String name = vr.getClass().getName() + i2;
                this.obtainApplicationContext().getAutowireCapableBeanFactory().initializeBean(vr, name);
            }
        }
        AnnotationAwareOrderComparator.sort(this.viewResolvers);
        this.cnmFactoryBean.setServletContext(servletContext);
    }

    @Override
    public void afterPropertiesSet() {
        if (this.contentNegotiationManager == null) {
            this.contentNegotiationManager = this.cnmFactoryBean.build();
        }
        if (this.viewResolvers == null || this.viewResolvers.isEmpty()) {
            this.logger.warn((Object)"No ViewResolvers configured");
        }
    }

    @Override
    @Nullable
    public View resolveViewName(String viewName, Locale locale) throws Exception {
        String mediaTypeInfo;
        List<View> candidateViews;
        View bestView;
        RequestAttributes attrs = RequestContextHolder.getRequestAttributes();
        Assert.state(attrs instanceof ServletRequestAttributes, "No current ServletRequestAttributes");
        List<MediaType> requestedMediaTypes = this.getMediaTypes(((ServletRequestAttributes)attrs).getRequest());
        if (requestedMediaTypes != null && (bestView = this.getBestView(candidateViews = this.getCandidateViews(viewName, locale, requestedMediaTypes), requestedMediaTypes, attrs)) != null) {
            return bestView;
        }
        String string = mediaTypeInfo = this.logger.isDebugEnabled() && requestedMediaTypes != null ? " given " + requestedMediaTypes.toString() : "";
        if (this.useNotAcceptableStatusCode) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Using 406 NOT_ACCEPTABLE" + mediaTypeInfo));
            }
            return NOT_ACCEPTABLE_VIEW;
        }
        this.logger.debug((Object)("View remains unresolved" + mediaTypeInfo));
        return null;
    }

    @Nullable
    protected List<MediaType> getMediaTypes(HttpServletRequest request) {
        Assert.state(this.contentNegotiationManager != null, "No ContentNegotiationManager set");
        try {
            ServletWebRequest webRequest = new ServletWebRequest(request);
            List<MediaType> acceptableMediaTypes = this.contentNegotiationManager.resolveMediaTypes(webRequest);
            List<MediaType> producibleMediaTypes = this.getProducibleMediaTypes(request);
            LinkedHashSet<MediaType> compatibleMediaTypes = new LinkedHashSet<MediaType>();
            for (MediaType acceptable : acceptableMediaTypes) {
                for (MediaType producible : producibleMediaTypes) {
                    if (!acceptable.isCompatibleWith(producible)) continue;
                    compatibleMediaTypes.add(this.getMostSpecificMediaType(acceptable, producible));
                }
            }
            ArrayList<MediaType> selectedMediaTypes = new ArrayList<MediaType>(compatibleMediaTypes);
            MimeTypeUtils.sortBySpecificity(selectedMediaTypes);
            return selectedMediaTypes;
        }
        catch (HttpMediaTypeNotAcceptableException ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)ex.getMessage());
            }
            return null;
        }
    }

    private List<MediaType> getProducibleMediaTypes(HttpServletRequest request) {
        Set mediaTypes = (Set)request.getAttribute(HandlerMapping.PRODUCIBLE_MEDIA_TYPES_ATTRIBUTE);
        if (!CollectionUtils.isEmpty(mediaTypes)) {
            return new ArrayList<MediaType>(mediaTypes);
        }
        return Collections.singletonList(MediaType.ALL);
    }

    private MediaType getMostSpecificMediaType(MediaType acceptType, MediaType produceType) {
        if (acceptType.isLessSpecific(produceType = produceType.copyQualityValue(acceptType))) {
            return produceType;
        }
        return acceptType;
    }

    private List<View> getCandidateViews(String viewName, Locale locale, List<MediaType> requestedMediaTypes) throws Exception {
        ArrayList<View> candidateViews = new ArrayList<View>();
        if (this.viewResolvers != null) {
            Assert.state(this.contentNegotiationManager != null, "No ContentNegotiationManager set");
            for (ViewResolver viewResolver : this.viewResolvers) {
                View view = viewResolver.resolveViewName(viewName, locale);
                if (view != null) {
                    candidateViews.add(view);
                }
                for (MediaType requestedMediaType : requestedMediaTypes) {
                    List<String> extensions = this.contentNegotiationManager.resolveFileExtensions(requestedMediaType);
                    for (String extension : extensions) {
                        String viewNameWithExtension = viewName + "." + extension;
                        view = viewResolver.resolveViewName(viewNameWithExtension, locale);
                        if (view == null) continue;
                        candidateViews.add(view);
                    }
                }
            }
        }
        if (!CollectionUtils.isEmpty(this.defaultViews)) {
            candidateViews.addAll(this.defaultViews);
        }
        return candidateViews;
    }

    @Nullable
    private View getBestView(List<View> candidateViews, List<MediaType> requestedMediaTypes, RequestAttributes attrs) {
        for (View candidateView : candidateViews) {
            SmartView smartView;
            if (!(candidateView instanceof SmartView) || !(smartView = (SmartView)candidateView).isRedirectView()) continue;
            return candidateView;
        }
        for (MediaType mediaType : requestedMediaTypes) {
            for (View candidateView : candidateViews) {
                MediaType candidateContentType;
                if (!StringUtils.hasText(candidateView.getContentType()) || !mediaType.isCompatibleWith(candidateContentType = MediaType.parseMediaType(candidateView.getContentType()))) continue;
                mediaType = mediaType.removeQualityValue();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Selected '" + String.valueOf(mediaType) + "' given " + String.valueOf(requestedMediaTypes)));
                }
                attrs.setAttribute(View.SELECTED_CONTENT_TYPE, mediaType, 0);
                return candidateView;
            }
        }
        return null;
    }
}

