/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs;

import com.atlassian.bitbucket.content.ContentService;
import com.atlassian.bitbucket.dmz.git.lfs.DmzLfsContentService;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BaseObject;
import com.atlassian.bitbucket.internal.scm.git.lfs.parser.BaseObjectParser;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.net.URLConnection;
import java.util.Objects;
import java.util.Optional;

public class DefaultLfsContentService
implements DmzLfsContentService {
    private final BaseObjectParser baseObjectParser;
    private final ContentService contentService;
    private final LfsService lfsService;

    public DefaultLfsContentService(@Nonnull BaseObjectParser baseObjectParser, @Nonnull ContentService contentService, @Nonnull LfsService lfsService) {
        this.baseObjectParser = baseObjectParser;
        this.contentService = contentService;
        this.lfsService = lfsService;
    }

    public Optional<URI> maybeGetDownloadUrl(@Nonnull Repository repository, @Nonnull String objectId, @Nonnull String path, @Nullable String contentDisposition) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(objectId, "objectId");
        Objects.requireNonNull(path, "path");
        if (!this.lfsService.isEnabled(repository)) {
            return Optional.empty();
        }
        long fileSize = this.contentService.getSize(repository, objectId, path).orElse(0L);
        if (fileSize < 100L || fileSize > 200L) {
            return Optional.empty();
        }
        byte[] rawPointer = this.readRawPointer(repository, objectId, path);
        Optional<BaseObject> pointer = this.baseObjectParser.parse(rawPointer);
        if (!pointer.isPresent()) {
            return Optional.empty();
        }
        String oid = pointer.get().getOid();
        String contentType = URLConnection.guessContentTypeFromName(path);
        return this.lfsService.createDownloadUrl(repository, oid, contentType, contentDisposition);
    }

    private byte[] readRawPointer(Repository repository, String objectId, String path) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(200);
        this.contentService.streamFile(repository, objectId, path, contentType -> out);
        return out.toByteArray();
    }
}

