/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs;

import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryForkedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.BadBatchRequestException;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsDisabledException;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.event.GitLfsBatchDownloadEvent;
import com.atlassian.bitbucket.internal.scm.git.lfs.event.GitLfsBatchUploadEvent;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.BatchResponse;
import com.atlassian.bitbucket.internal.scm.git.lfs.model.RequestOperationType;
import com.atlassian.bitbucket.internal.scm.git.lfs.settings.GitLfsSettingsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.store.StoreAccessor;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;

public class DefaultLfsService
implements LfsService {
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final ApplicationMode mode;
    private final GitLfsSettingsService settingsService;
    private final StoreAccessor storeAccessor;
    private final PermissionValidationService validationService;

    public DefaultLfsService(@Nonnull EventPublisher eventPublisher, @Nonnull I18nService i18nService, @Nonnull ApplicationPropertiesService propertiesService, @Nonnull GitLfsSettingsService settingsService, @Nonnull StoreAccessor storeAccessor, @Nonnull PermissionValidationService validationService) {
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.settingsService = settingsService;
        this.storeAccessor = storeAccessor;
        this.validationService = validationService;
        this.mode = propertiesService.getMode();
    }

    @Override
    @Nonnull
    public Optional<URI> createDownloadUrl(@Nonnull Repository repository, @Nonnull String oid, @Nullable String contentType, @Nullable String contentDisposition) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(oid, "oid");
        this.validateGitLfsEnabled(repository);
        this.validationService.validateRepositoryAccessible(repository);
        return this.storeAccessor.createDownloadUrl(repository, oid, contentType, contentDisposition);
    }

    @Override
    public void delete(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.storeAccessor.delete(repository);
        this.settingsService.cleanup(repository);
    }

    @Override
    public void disable() {
        this.validationService.validateForGlobal(Permission.ADMIN);
        this.settingsService.setEnabled(false);
    }

    @Override
    public void disable(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.validationService.validateForRepository(repository, Permission.REPO_ADMIN);
        this.settingsService.setEnabled(repository, false);
    }

    @Override
    public void enable() {
        this.validationService.validateForGlobal(Permission.ADMIN);
        this.settingsService.setEnabled(true);
    }

    @Override
    public void enable(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.validationService.validateForRepository(repository, Permission.REPO_ADMIN);
        this.settingsService.setEnabled(repository, true);
    }

    @Override
    @Nonnull
    public BatchResponse handleBatchRequest(@Nonnull Repository repository, @Nonnull BatchRequest request) {
        Objects.requireNonNull(repository, "repository");
        Objects.requireNonNull(request, "request");
        this.validateGitLfsEnabled(repository);
        this.validatePermission(repository, request.getType());
        try {
            this.publishBatchActivityEvents(repository, request.getType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.storeAccessor.handleBatchRequest(repository, request);
    }

    @Override
    public boolean isEnabled() {
        return this.isMirror() || this.settingsService.isEnabled();
    }

    @Override
    public boolean isEnabled(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        this.validationService.validateRepositoryAccessible(repository);
        return this.isMirror() || this.settingsService.isEnabled() && this.settingsService.isEnabled(repository);
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.delete(event.getRepository());
    }

    @EventListener
    public void onRepositoryForked(RepositoryForkedEvent event) {
        Repository fork = event.getRepository();
        Repository origin = fork.getOrigin();
        if (this.settingsService.isEnabled() && origin != null) {
            if (this.isEnabled(origin)) {
                this.enable(fork);
            } else {
                this.disable(fork);
            }
        }
    }

    private boolean isMirror() {
        return this.mode == ApplicationMode.MIRROR;
    }

    private void publishBatchActivityEvents(Repository repository, RequestOperationType operationType) {
        if (operationType == RequestOperationType.DOWNLOAD) {
            this.eventPublisher.publish((Object)new GitLfsBatchDownloadEvent(this, repository));
        } else if (operationType == RequestOperationType.UPLOAD) {
            this.eventPublisher.publish((Object)new GitLfsBatchUploadEvent(this, repository));
        }
    }

    private void validateGitLfsEnabled(Repository repository) {
        if (!this.isEnabled(repository)) {
            throw new GitLfsDisabledException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.disabled", new Object[0]));
        }
    }

    private void validatePermission(Repository repository, RequestOperationType operationType) {
        if (operationType == RequestOperationType.DOWNLOAD) {
            this.validationService.validateRepositoryAccessible(repository);
        } else if (operationType == RequestOperationType.UPLOAD) {
            this.validationService.validateForRepository(repository, Permission.REPO_WRITE);
        } else {
            throw new BadBatchRequestException(this.i18nService.getMessage("bitbucket.scm.git.lfs.request.unsupported.operation", new Object[]{operationType.name()}));
        }
    }
}

