/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs;

import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GitLfsUtils {
    private static final Pattern SHA256_PATTERN = Pattern.compile("[a-fA-F0-9]{64}");

    private GitLfsUtils() {
    }

    public static String getLockOwnerName(@Nonnull ApplicationUser lockOwner) {
        Objects.requireNonNull(lockOwner, "lockOwner");
        if (StringUtils.isEmpty((CharSequence)lockOwner.getEmailAddress())) {
            return lockOwner.getDisplayName();
        }
        return String.format("%s (%s)", lockOwner.getDisplayName(), lockOwner.getEmailAddress());
    }

    public static boolean isValidSha256(String hash) {
        return hash != null && SHA256_PATTERN.matcher(hash).matches();
    }
}

