/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.scm.git.lfs.dao.AoGitLfsRepositoryConfig;
import com.atlassian.bitbucket.internal.scm.git.lfs.dao.GitLfsRepositoryConfigDao;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;

public class AoGitLfsRepositoryConfigDao
extends AbstractAoDao
implements GitLfsRepositoryConfigDao {
    public AoGitLfsRepositoryConfigDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    public void cleanup(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        AoGitLfsRepositoryConfig config = this.findConfig(repository);
        if (config != null) {
            this.ao.delete(new RawEntity[]{config});
        }
    }

    @Override
    public boolean isEnabled(@Nonnull Repository repository) {
        Objects.requireNonNull(repository, "repository");
        AoGitLfsRepositoryConfig config = this.findConfig(repository);
        return config != null ? config.isEnabled() : false;
    }

    @Override
    public void setEnabled(@Nonnull Repository repository, boolean enabled) {
        Objects.requireNonNull(repository, "repository");
        AoGitLfsRepositoryConfig config = this.findConfig(repository);
        if (config == null) {
            config = this.create(repository);
        }
        config.setEnabled(enabled);
        config.save();
    }

    private AoGitLfsRepositoryConfig create(@Nonnull Repository repository) {
        AoGitLfsRepositoryConfig config = this.findConfig(repository);
        if (config == null) {
            config = (AoGitLfsRepositoryConfig)this.ao.create(AoGitLfsRepositoryConfig.class, new DBParam[]{new DBParam("IS_ENABLED", (Object)false), new DBParam("REPOSITORY_ID", (Object)repository.getId())});
        }
        return config;
    }

    private AoGitLfsRepositoryConfig findConfig(@Nonnull Repository repository) {
        return (AoGitLfsRepositoryConfig)this.ao.get(AoGitLfsRepositoryConfig.class, (Object)repository.getId());
    }
}

