/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectByteRange;
import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;

public class ReadObjectRequest {
    private final String oid;
    private final ObjectByteRange range;
    private final Repository repository;

    private ReadObjectRequest(@Nonnull Builder builder) {
        this.oid = builder.oid;
        this.repository = builder.repository;
        this.range = builder.range;
    }

    @Nonnull
    public String getOid() {
        return this.oid;
    }

    @Nonnull
    public Optional<ObjectByteRange> getRange() {
        return Optional.ofNullable(this.range);
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder {
        private final String oid;
        private final Repository repository;
        private ObjectByteRange range;

        public Builder(@Nonnull Repository repository, @Nonnull String oid) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.oid = Objects.requireNonNull(oid, "oid");
        }

        public Builder range(ObjectByteRange range) {
            this.range = range;
            return this;
        }

        @Nonnull
        public ReadObjectRequest build() {
            return new ReadObjectRequest(this);
        }
    }
}

