/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.embedded;

import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.dmz.throttle.DmzThrottleService;
import com.atlassian.bitbucket.dmz.throttle.Ticket;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectByteRange;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.ObjectStreamingOutput;
import com.atlassian.bitbucket.internal.scm.git.lfs.embedded.RangeNotSatisfiableException;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.ws.rs.WebApplicationException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class ThrottleAwareStreamingOutput
implements ObjectStreamingOutput {
    private static final int COPY_BUFFER_SIZE = 8192;
    private final File file;
    private final I18nService i18nService;
    private final ObjectByteRange range;
    private final String resourceName;
    private final DmzThrottleService throttleService;

    ThrottleAwareStreamingOutput(@Nonnull File file, @Nullable ObjectByteRange range, @Nonnull DmzThrottleService throttleService, @Nonnull String resourceName, @Nonnull I18nService i18nService) {
        ThrottleAwareStreamingOutput.validateRange(i18nService, file, range);
        this.file = Objects.requireNonNull(file, "file");
        this.i18nService = Objects.requireNonNull(i18nService, "i18nService");
        this.throttleService = Objects.requireNonNull(throttleService, "throttleService");
        this.resourceName = Objects.requireNonNull(resourceName, "resourceName");
        this.range = range;
    }

    @Override
    @Nonnull
    public Optional<ObjectByteRange> range() {
        return Optional.ofNullable(this.range);
    }

    public void write(OutputStream output) throws IOException, WebApplicationException {
        try (Ticket ignored = this.throttleService.acquireTicket(this.resourceName);
             FileInputStream input = new FileInputStream(this.file);){
            byte[] buffer = new byte[8192];
            if (this.range == null) {
                IOUtils.copyLarge((InputStream)input, (OutputStream)output, (byte[])buffer);
            } else {
                long start = this.range.getRangeStart();
                long end = Math.min(this.range.getRangeEnd(), this.file.length() - 1L);
                IOUtils.copyLarge((InputStream)input, (OutputStream)output, (long)start, (long)(end - start + 1L), (byte[])buffer);
            }
        }
        catch (FileNotFoundException ignored2) {
            throw new NoSuchEntityException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.embeddedstore.object.notexist", new Object[0]));
        }
    }

    private static void validateRange(I18nService i18nService, File file, ObjectByteRange range) {
        if (range != null) {
            long end;
            long length = file.length();
            long start = range.getRangeStart();
            if (start > (end = range.getRangeEnd()) || end < 0L) {
                throw new RangeNotSatisfiableException(i18nService.createKeyedMessage("bitbucket.scm.git.lfs.http.range.invalid", new Object[]{range}));
            }
            if (start >= length || start < 0L) {
                throw new RangeNotSatisfiableException(i18nService.createKeyedMessage("bitbucket.scm.git.lfs.http.range.invalid.start", new Object[]{start, length - 1L}));
            }
        }
    }
}

