/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.hook;

import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.dmz.process.AbstractLineHandler;
import com.atlassian.bitbucket.dmz.process.NioProcess;
import com.atlassian.bitbucket.dmz.process.NioStdioHandler;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.hook.DiffTreeHandler;
import jakarta.annotation.Nonnull;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class AsyncNameOnlyDiffTreeStdioHandler
extends AbstractLineHandler
implements DiffTreeHandler,
NioStdioHandler<Void> {
    protected static final String DIFF_TREE_END = "@@diff_tree_end@@";
    protected static final String NO_SUCH_COMMIT = "@@no_such_commit@@";
    private final I18nService i18nService;
    private final BlockingQueue<String> pathQueue;
    private State state;
    private volatile boolean running;

    public AsyncNameOnlyDiffTreeStdioHandler(I18nService i18nService) {
        super(StandardCharsets.UTF_8);
        this.i18nService = i18nService;
        this.pathQueue = new LinkedBlockingQueue<String>();
        this.running = true;
    }

    @Override
    public void cancel() {
        this.running = false;
        this.closeStdin();
        super.cancel();
    }

    public Void getOutput() {
        return null;
    }

    public void onExit(int exitCode) {
        this.running = false;
    }

    public void onStart(@Nonnull NioProcess process) {
        super.onStart(process);
        this.state = State.COMMIT_HEADER;
    }

    public boolean onStdinReady(@Nonnull ByteBuffer buffer) {
        buffer.flip();
        return false;
    }

    @Override
    public void processCommit(@Nonnull String commitHash, @Nonnull Consumer<String> pathConsumer) throws InterruptedException {
        Objects.requireNonNull(commitHash, "commitHash");
        Objects.requireNonNull(pathConsumer);
        if (this.running) {
            this.state = State.COMMIT_HEADER;
            this.requestObject(commitHash);
            do {
                String path;
                if ((path = this.pathQueue.poll(100L, TimeUnit.MILLISECONDS)) == null) continue;
                if (NO_SUCH_COMMIT.equals(path)) {
                    this.closeStdin();
                    this.running = false;
                    throw new NoSuchCommitException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.hooks.verifylocks.nosuchcommit", new Object[]{commitHash}), commitHash);
                }
                if (DIFF_TREE_END.equals(path)) {
                    return;
                }
                pathConsumer.accept(path);
            } while (this.running);
        } else {
            throw new IllegalStateException("git diff-tree process has already terminated");
        }
        throw new IllegalStateException("git diff-tree process terminated unexpectedly");
    }

    protected boolean onStdout(@Nonnull String line, boolean truncated) {
        if (!this.running) {
            return false;
        }
        String path = line;
        if (this.state == State.COMMIT_HEADER) {
            if (DIFF_TREE_END.equals(line)) {
                path = NO_SUCH_COMMIT;
            }
            this.state = State.PATHS;
        }
        this.pathQueue.offer(path);
        return true;
    }

    private void requestObject(String objectId) {
        StringBuilder builder = new StringBuilder();
        builder.append(objectId).append("\n");
        builder.append(DIFF_TREE_END).append("\n");
        this.process.writeStdin(ByteBuffer.wrap(builder.toString().getBytes(StandardCharsets.UTF_8)));
    }

    private static enum State {
        COMMIT_HEADER,
        PATHS;

    }
}

