/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.hook;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.hook.repository.PreRepositoryHookContext;
import com.atlassian.bitbucket.hook.repository.PullRequestMergeHookRequest;
import com.atlassian.bitbucket.hook.repository.RepositoryHookResult;
import com.atlassian.bitbucket.hook.repository.RepositoryMergeCheck;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.GitLfsUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.PullRequestChangesCommandParameters;
import com.atlassian.bitbucket.user.ApplicationUser;
import jakarta.annotation.Nonnull;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VerifyLfsLocksMergeCheck
implements RepositoryMergeCheck {
    private static final Logger log = LoggerFactory.getLogger(VerifyLfsLocksMergeCheck.class);
    private final AuthenticationContext authenticationContext;
    private final I18nService i18nService;
    private final LfsLockService lfsLockService;
    private final LfsService lfsService;
    private final ScmService scmService;

    public VerifyLfsLocksMergeCheck(AuthenticationContext authenticationContext, I18nService i18nService, LfsLockService lfsLockService, LfsService lfsService, ScmService scmService) {
        this.authenticationContext = authenticationContext;
        this.i18nService = i18nService;
        this.lfsLockService = lfsLockService;
        this.lfsService = lfsService;
        this.scmService = scmService;
    }

    @Nonnull
    public RepositoryHookResult preUpdate(@Nonnull PreRepositoryHookContext context, @Nonnull PullRequestMergeHookRequest request) {
        Repository repository = request.getRepository();
        if (!"git".equals(repository.getScmId()) || !this.lfsService.isEnabled(repository)) {
            return RepositoryHookResult.accepted();
        }
        ApplicationUser authenticatedUser = this.authenticationContext.getCurrentUser();
        Map<String, ApplicationUser> pathsLockedByOtherUsers = this.lfsLockService.getEnforceableLocks(repository);
        if (pathsLockedByOtherUsers.isEmpty()) {
            return RepositoryHookResult.accepted();
        }
        return this.checkPullRequestMerge(request, authenticatedUser, pathsLockedByOtherUsers);
    }

    private RepositoryHookResult checkPullRequestMerge(PullRequestMergeHookRequest request, ApplicationUser authenticatedUser, Map<String, ApplicationUser> pathsLockedByOtherUsers) {
        PullRequest pullRequest = request.getPullRequest();
        Repository repository = request.getRepository();
        RepositoryHookResult.Builder resultBuilder = new RepositoryHookResult.Builder();
        PullRequestChangesCommandParameters parameters = ((PullRequestChangesCommandParameters.Builder)new PullRequestChangesCommandParameters.Builder().maxChanges(Integer.MAX_VALUE)).build();
        this.scmService.getPullRequestCommandFactory(pullRequest).changes(parameters, change -> {
            String changedPath = change.getPath().toString();
            ApplicationUser lockHolder = (ApplicationUser)pathsLockedByOtherUsers.get(changedPath);
            if (lockHolder == null) {
                if (change.getSrcPath() != null) {
                    changedPath = change.getSrcPath().toString();
                    lockHolder = (ApplicationUser)pathsLockedByOtherUsers.get(changedPath);
                    if (lockHolder == null) {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            log.debug("{}: {} blocked from merging pull request #{} as it modifies '{}' which is currently locked by {}", new Object[]{repository, authenticatedUser.getSlug(), pullRequest.getId(), changedPath, lockHolder.getSlug()});
            resultBuilder.veto(this.i18nService.getMessage("bitbucket.scm.git.lfs.verifylocks.mergecheck.vetoed.summary", new Object[0]), this.i18nService.getMessage("bitbucket.scm.git.lfs.verifylocks.mergecheck.vetoed.detail", new Object[]{changedPath, GitLfsUtils.getLockOwnerName(lockHolder)}));
            return false;
        }).call();
        return resultBuilder.build();
    }
}

