/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.LfsService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.BaseLfsHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsBatchHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsBatchScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.http.HttpRequestDetails;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;

public class DefaultLfsBatchHttpScmRequestHandler
extends BaseLfsHttpScmRequestHandler
implements LfsBatchHttpScmRequestHandler {
    protected final AuthenticationContext authenticationContext;
    protected final LfsService lfsService;

    public DefaultLfsBatchHttpScmRequestHandler(@Nonnull AuthenticationContext authenticationContext, @Nonnull I18nService i18nService, @Nonnull LfsService lfsService, @Nonnull RepositoryService repositoryService) {
        super(repositoryService, i18nService);
        this.authenticationContext = Objects.requireNonNull(authenticationContext, "authenticationContext");
        this.lfsService = Objects.requireNonNull(lfsService, "lfsService");
    }

    @Nonnull
    public Optional<HttpScmRequest> create(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(response, "response");
        Matcher batchApiMatcher = LfsHttpScmUtils.LFS_HTTP_BATCH_PATH.matcher(request.getPathInfo());
        if (batchApiMatcher.matches()) {
            Repository repository = this.getRepositoryOrThrow(batchApiMatcher);
            return Optional.of(new LfsBatchScmRequest(this.authenticationContext, request, response, this.i18nService, this.lfsService, repository));
        }
        return Optional.empty();
    }

    public boolean supports(@Nonnull HttpRequestDetails requestDetails) {
        Objects.requireNonNull(requestDetails, "requestDetails");
        if (requestDetails.getPathInfo() == null) {
            return false;
        }
        return LfsHttpScmUtils.LFS_HTTP_BATCH_PATH.matcher(requestDetails.getPathInfo()).matches();
    }
}

