/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.BaseLfsLockScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLock;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockListRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.lock.LfsLockService;
import com.atlassian.bitbucket.internal.scm.git.lfs.rest.lock.RestLfsLockPageForVerification;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.util.MoreStreams;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.Collectors;

public class LfsLockVerifyScmRequest
extends BaseLfsLockScmRequest {
    public LfsLockVerifyScmRequest(@Nonnull AuthenticationContext authenticationContext, @Nonnull I18nService i18nService, @Nonnull LfsLockService lfsLockService, @Nonnull Repository repository, @Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        super(authenticationContext, i18nService, lfsLockService, repository, request, response);
    }

    @Override
    protected void doHandleRequest() throws IOException {
        RestLfsLockVerificationRequest verificationRequest = LfsLockVerifyScmRequest.deserialize((InputStream)this.request.getInputStream(), RestLfsLockVerificationRequest.class);
        int start = verificationRequest.getCursor().orElse(0);
        int limit = verificationRequest.getLimit().orElse(100);
        Page<LfsLock> locks = this.lfsLockService.listLocks(new LfsLockListRequest.Builder(this.repository).build(), PageUtils.newRequest((int)start, (int)limit));
        int currentUserId = this.authenticationContext.getCurrentUser().getId();
        Map<Boolean, List<LfsLock>> oursAndTheirs = MoreStreams.streamIterable((Iterable)locks.getValues()).collect(Collectors.partitioningBy(lock -> lock.getOwner().getId() == currentUserId));
        List<LfsLock> usersLocks = oursAndTheirs.get(true);
        List<LfsLock> othersLocks = oursAndTheirs.get(false);
        this.response.setStatus(200);
        try (ServletOutputStream outputStream = this.response.getOutputStream();){
            LfsLockVerifyScmRequest.serialize((OutputStream)outputStream, (Object)new RestLfsLockPageForVerification(usersLocks, othersLocks, Optional.ofNullable(locks.getNextPageRequest()).map(PageRequest::getStart).orElse(null)));
        }
    }

    @JsonSerialize
    private static class RestLfsLockVerificationRequest
    extends RestMapEntity {
        RestLfsLockVerificationRequest() {
        }

        @Nonnull
        OptionalInt getCursor() {
            return this.getOptionalIntProperty("cursor");
        }

        @Nonnull
        OptionalInt getLimit() {
            return this.getOptionalIntProperty("limit");
        }
    }
}

