/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.http.lock;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.BaseLfsHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsHttpScmUtils;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.LfsLockHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.MirrorLfsLockHttpScmRequest;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.UpstreamLfsClient;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.scm.http.HttpRequestDetails;
import com.atlassian.bitbucket.scm.http.HttpScmRequest;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class MirrorLfsLockHttpScmRequestHandler
extends BaseLfsHttpScmRequestHandler
implements LfsLockHttpScmRequestHandler {
    private final UpstreamLfsClient upstreamLfsClient;

    public MirrorLfsLockHttpScmRequestHandler(@Nonnull I18nService i18nService, @Nonnull RepositoryService repositoryService, @Nonnull UpstreamLfsClient upstreamLfsClient) {
        super(repositoryService, i18nService);
        this.upstreamLfsClient = Objects.requireNonNull(upstreamLfsClient, "upstreamLfsClient");
    }

    @Nonnull
    public Optional<HttpScmRequest> create(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response) {
        Objects.requireNonNull(request, "request");
        Objects.requireNonNull(response, "response");
        if (!this.supports(HttpRequestDetails.ofServletRequest((HttpServletRequest)request))) {
            return Optional.empty();
        }
        Matcher lockApiMatcher = LfsHttpScmUtils.LFS_HTTP_LOCK_PATH.matcher(request.getPathInfo());
        if (lockApiMatcher.matches()) {
            Repository repository = this.getRepositoryOrThrow(lockApiMatcher);
            return Optional.of(new MirrorLfsLockHttpScmRequest(this.i18nService, StringUtils.defaultString((String)lockApiMatcher.group("lockpath")), repository, response, this.upstreamLfsClient));
        }
        return Optional.empty();
    }

    public boolean supports(@Nonnull HttpRequestDetails requestDetails) {
        Objects.requireNonNull(requestDetails, "requestDetails");
        return LfsHttpScmUtils.isLockApiCall(requestDetails);
    }
}

