/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.jwt;

import com.atlassian.bitbucket.internal.scm.git.lfs.jwt.GitLfsJwtHelper;
import com.atlassian.jwt.CanonicalHttpRequest;
import com.atlassian.jwt.exception.JwtInvalidClaimException;
import com.atlassian.jwt.exception.JwtVerificationException;
import com.atlassian.jwt.reader.JwtClaimVerifier;
import com.atlassian.jwt.reader.JwtClaimVerifiersBuilder;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitLfsApiClaimVerifiersBuilder
implements JwtClaimVerifiersBuilder {
    private static final Pattern GIT_LFS_API_PATTERN = Pattern.compile("/scm/(?<projectKey>~[a-zA-Z0-9\\-_.]+|[a-zA-Z][a-zA-Z0-9_\\-]*)/(?<repoSlug>[\\p{Alnum}][\\w\\-\\.]*).git/info/lfs/.+");
    private final GitLfsJwtHelper gitLfsJwtHelper;

    public GitLfsApiClaimVerifiersBuilder(GitLfsJwtHelper gitLfsJwtHelper) {
        this.gitLfsJwtHelper = gitLfsJwtHelper;
    }

    public Map<String, ? extends JwtClaimVerifier> build(CanonicalHttpRequest request) {
        return ImmutableMap.of((Object)"repo", (Object)new GitLfsActionClaimVerifier(request));
    }

    private class GitLfsActionClaimVerifier
    implements JwtClaimVerifier {
        private final String relativePath;

        public GitLfsActionClaimVerifier(CanonicalHttpRequest request) {
            this.relativePath = request.getRelativePath();
        }

        public void verify(@Nonnull Object repoClaim) throws JwtVerificationException {
            String repoSlug;
            Matcher lfsApiMatcher = GIT_LFS_API_PATTERN.matcher(this.relativePath);
            if (!lfsApiMatcher.matches()) {
                throw new JwtInvalidClaimException("Invalid Git LFS path: " + this.relativePath);
            }
            String projectKey = lfsApiMatcher.group("projectKey");
            String expectedRepoClaim = GitLfsApiClaimVerifiersBuilder.this.gitLfsJwtHelper.getClaimFromParameters(projectKey, repoSlug = lfsApiMatcher.group("repoSlug"));
            if (!expectedRepoClaim.equals(repoClaim.toString())) {
                throw new JwtInvalidClaimException(String.format("JWT repo claim (%s) does not match repository URL: %s", repoClaim, this.relativePath));
            }
        }
    }
}

