/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.jwt;

import com.atlassian.bitbucket.auth.AuthenticationResult;
import com.atlassian.bitbucket.auth.HttpAuthenticationContext;
import com.atlassian.bitbucket.auth.HttpAuthenticationHandler;
import com.atlassian.bitbucket.auth.InactiveUserAuthenticationException;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.LfsBatchHttpScmRequestHandler;
import com.atlassian.bitbucket.internal.scm.git.lfs.http.lock.LfsLockHttpScmRequestHandler;
import com.atlassian.bitbucket.scm.http.HttpRequestDetails;
import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.UserService;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class GitLfsJwtHttpAuthenticationHandler
implements HttpAuthenticationHandler {
    private final ApplicationMode applicationMode;
    private final LfsBatchHttpScmRequestHandler batchRequestHandler;
    private final I18nService i18nService;
    private final LfsLockHttpScmRequestHandler lockRequestHandler;
    private final UserService userService;

    public GitLfsJwtHttpAuthenticationHandler(LfsBatchHttpScmRequestHandler batchRequestHandler, I18nService i18nService, LfsLockHttpScmRequestHandler lockRequestHandler, ApplicationPropertiesService propertiesService, UserService userService) {
        this.applicationMode = propertiesService.getMode();
        this.batchRequestHandler = batchRequestHandler;
        this.i18nService = i18nService;
        this.lockRequestHandler = lockRequestHandler;
        this.userService = userService;
    }

    public AuthenticationResult performAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
        Object jwtSubject;
        HttpServletRequest request = authenticationContext.getRequest();
        if (ApplicationMode.DEFAULT == this.applicationMode && this.isLfsRequest(request) && (jwtSubject = request.getAttribute("jwt.subject")) != null) {
            ApplicationUser user = this.userService.getUserById(Integer.parseInt(String.valueOf(jwtSubject)));
            if (user == null || !this.userService.isUserActive(user)) {
                throw new InactiveUserAuthenticationException(this.i18nService.createKeyedMessage("bitbucket.scm.git.lfs.http.inactiveuser", new Object[]{jwtSubject}));
            }
            return new AuthenticationResult.Builder(user).build();
        }
        return null;
    }

    public void validateAuthentication(@Nonnull HttpAuthenticationContext authenticationContext) {
    }

    private boolean isLfsRequest(HttpServletRequest request) {
        HttpRequestDetails requestDetails = HttpRequestDetails.ofServletRequest((HttpServletRequest)request);
        return StringUtils.startsWith((CharSequence)request.getServletPath(), (CharSequence)"/rest/git-lfs/storage") || this.batchRequestHandler.supports(requestDetails) || this.lockRequestHandler.supports(requestDetails);
    }
}

