/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.lock;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class LfsLockCreationRequest {
    private final String path;
    private final Repository repository;

    private LfsLockCreationRequest(@Nonnull String path, @Nonnull Repository repository) {
        this.path = path;
        this.repository = repository;
    }

    @Nonnull
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder {
        private String path;
        private Repository repository;

        public Builder(@Nonnull String path, @Nonnull Repository repository) {
            this.path = Objects.requireNonNull(path, "path");
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        public LfsLockCreationRequest build() {
            return new LfsLockCreationRequest(this.path, this.repository);
        }
    }
}

