/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.lock;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class LfsLockDeletionRequest {
    private final boolean force;
    private final int id;
    private final Repository repository;

    private LfsLockDeletionRequest(boolean force, int id, @Nonnull Repository repository) {
        this.force = force;
        this.id = id;
        this.repository = repository;
    }

    public int getId() {
        return this.id;
    }

    public boolean isForce() {
        return this.force;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public static class Builder {
        private boolean force;
        private int id;
        private Repository repository;

        public Builder(int id, @Nonnull Repository repository) {
            this.id = id;
            this.repository = Objects.requireNonNull(repository, "repository");
        }

        public LfsLockDeletionRequest build() {
            return new LfsLockDeletionRequest(this.force, this.id, this.repository);
        }

        public Builder force(boolean force) {
            this.force = force;
            return this;
        }
    }
}

