/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.lock;

import com.atlassian.bitbucket.repository.Repository;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;

public class LfsLockListRequest {
    private final Integer id;
    private final String path;
    private final Repository repository;
    private final boolean sendAnalytics;

    private LfsLockListRequest(@Nonnull Builder builder) {
        this.id = builder.id;
        this.path = builder.path;
        this.repository = builder.repository;
        this.sendAnalytics = builder.sendAnalytics;
    }

    @Nullable
    public Integer getId() {
        return this.id;
    }

    @Nullable
    public String getPath() {
        return this.path;
    }

    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    boolean isSendingAnalytics() {
        return this.sendAnalytics;
    }

    public static class Builder {
        private Integer id;
        private String path;
        private Repository repository;
        private boolean sendAnalytics;

        public Builder(@Nonnull Repository repository) {
            this.repository = Objects.requireNonNull(repository, "repository");
            this.sendAnalytics = true;
        }

        @Nonnull
        public LfsLockListRequest build() {
            return new LfsLockListRequest(this);
        }

        @Nonnull
        public Builder id(int id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull String path) {
            this.path = Objects.requireNonNull(path, "path");
            return this;
        }

        @Nonnull
        public Builder sendAnalytics(boolean sendAnalytics) {
            this.sendAnalytics = sendAnalytics;
            return this;
        }
    }
}

