/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.scm.git.lfs.mirror;

import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.DigestValidatingInputStream;
import com.atlassian.bitbucket.internal.scm.git.lfs.mirror.DigestValidatingOutputStream;
import com.atlassian.util.contentcache.CacheExpiryStrategy;
import com.atlassian.util.contentcache.internal.AbstractCacheEntry;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;

public class LfsCacheEntry
extends AbstractCacheEntry {
    private final Path objectFile;
    private volatile boolean created;

    public LfsCacheEntry(@Nonnull String cacheKey, @Nonnull CacheExpiryStrategy cacheExpiryStrategy, @Nonnull Path objectFile) {
        super(cacheKey, "LFS", null, cacheExpiryStrategy);
        this.objectFile = Objects.requireNonNull(objectFile, "objectFile");
    }

    protected void doCleanup() {
    }

    @Nonnull
    protected InputStream doCreateCacheInputStream() throws IOException {
        Preconditions.checkState((boolean)this.created, (Object)"Cache file hasn't been created yet");
        return new DigestValidatingInputStream(Files.newInputStream(this.objectFile, new OpenOption[0]), this.objectFile);
    }

    @Nonnull
    protected OutputStream doCreateCacheOutputStream() throws IOException {
        Preconditions.checkState((!this.created ? 1 : 0) != 0, (Object)"Cache file has already been created");
        Files.createDirectories(this.objectFile.getParent(), new FileAttribute[0]);
        OutputStream outputStream = Files.newOutputStream(this.objectFile, new OpenOption[0]);
        this.created = true;
        return new DigestValidatingOutputStream(outputStream, this.objectFile);
    }
}

